/*
 * Decompiled with CFR 0.152.
 */
package uqmanimationtool;

import com.sun.corba.se.impl.orbutil.concurrent.Mutex;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import uqmanimationtool.ImagePanel;
import uqmanimationtool.Notes;
import uqmanimationtool.Settings;

public class MainFrame
extends JFrame {
    Mutex mu = new Mutex();
    DefaultListModel dm = new DefaultListModel();
    ArrayList<ImagePanel> imgpanels = new ArrayList();
    Color hotspotColor = Color.red;
    ImagePanel hotspot;
    TimerTask t;
    Timer tim;
    boolean timon = false;
    File editingFile;
    Settings settings;
    XStream xstream;
    private static final String CONFFILE = "uqmanimationtool.conf";
    private int mousestart_x;
    private int mousestart_y;
    private int mousestart_loc_x;
    private int mousestart_loc_y;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JSlider jSlider2;

    public MainFrame() {
        this.initComponents();
        try {
            this.initSettings();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initMain();
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                block8: {
                    try {
                        if (MainFrame.this.jList1.getSelectedIndex() == -1) break block8;
                        MainFrame.this.mu.acquire();
                        if (MainFrame.this.jCheckBox2.isSelected()) {
                            for (ImagePanel i : MainFrame.this.imgpanels) {
                                i.setVisible(false);
                            }
                        }
                        try {
                            MainFrame.this.jPanel1.setComponentZOrder(MainFrame.this.imgpanels.get(MainFrame.this.jList1.getSelectedIndex()), 0);
                            MainFrame.this.imgpanels.get(MainFrame.this.jList1.getSelectedIndex()).setVisible(true);
                            if (MainFrame.this.jCheckBox3.isSelected()) {
                                MainFrame.this.hotspot.setVisible(true);
                                MainFrame.this.jPanel1.setComponentZOrder(MainFrame.this.hotspot, 0);
                            } else {
                                MainFrame.this.hotspot.setVisible(false);
                            }
                            MainFrame.this.jPanel1.updateUI();
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        MainFrame.this.mu.release();
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.tim = new Timer();
        this.jPanel1.addMouseListener(new MyMouseListener());
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                OutputStreamWriter fo = null;
                try {
                    MainFrame.this.settings.hideDupe = MainFrame.this.jCheckBox1.isSelected();
                    MainFrame.this.settings.showOnlySelected = MainFrame.this.jCheckBox2.isSelected();
                    String xml = MainFrame.this.xstream.toXML(MainFrame.this.settings);
                    fo = new FileWriter(MainFrame.CONFFILE);
                    fo.write(xml);
                    fo.close();
                    System.exit(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        fo.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    private ImagePanel generateHotspot(int width, int height, int zoom) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, this.hotspotColor.getRGB());
        ImagePanel ip = new ImagePanel(bi, 0, 0, zoom);
        ip.setVisible(true);
        ip.setOpaque(false);
        return ip;
    }

    private void initSettings() throws FileNotFoundException, IOException {
        this.settings = new Settings();
        this.xstream = new XStream(new DomDriver());
        this.xstream.alias("UQMAnimationToolSettings", Settings.class);
        File f = new File(CONFFILE);
        if (f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            this.settings = (Settings)this.xstream.fromXML(fis);
            fis.close();
        }
        this.jCheckBox1.setSelected(this.settings.hideDupe);
        this.jCheckBox2.setSelected(this.settings.showOnlySelected);
        this.hotspotColor = this.settings.hotspotColor == null ? Color.red : this.settings.hotspotColor;
    }

    public void initMain() {
        try {
            this.initStuffs();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "SOMETHING WENT HORRIBLY WRONG ON INITIALIZING: " + e.toString());
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void initStuffs() throws FileNotFoundException, NoSuchAlgorithmException {
        try {
            JFileChooser fc = new JFileChooser(this.settings.lastDirPath);
            fc.addChoosableFileFilter(new FileNameExtensionFilter("ani file", "ani", "med", "big", "sml"));
            int returnval = fc.showOpenDialog(this);
            this.jList1.setModel(this.dm);
            this.dm.clear();
            if (returnval == 0) {
                this.editingFile = fc.getSelectedFile();
                this.parseFile(this.editingFile);
            } else {
                JOptionPane.showMessageDialog(this, "No file selected. Quitting.");
                this.dispose();
                System.exit(0);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseFile(File f) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        this.settings.lastDirPath = f.getParent();
        this.jPanel1.removeAll();
        this.imgpanels.clear();
        this.dm.clear();
        this.jLabel2.setText("Loaded: " + f.getAbsolutePath() + " at " + System.currentTimeMillis());
        System.err.println(f.getParent());
        BufferedReader br = new BufferedReader(new FileReader(f));
        String prevline = "";
        int lnr = 0;
        boolean negativeFound = false;
        while (br.ready()) {
            ++lnr;
            String line = br.readLine();
            if (!line.startsWith("#")) {
                String[] splitted = null;
                if (!this.jCheckBox1.isSelected() || this.jCheckBox1.isSelected() && !line.equals(prevline)) {
                    try {
                        splitted = line.split(" ");
                        String fname = f.getParent() + "\\" + splitted[0];
                        int xoff = Integer.valueOf(splitted[3]);
                        int yoff = Integer.valueOf(splitted[4]);
                        if (xoff < 0 || yoff < 0) {
                            negativeFound = true;
                        }
                        ImagePanel io = new ImagePanel(fname, xoff *= -1, yoff *= -1, this.jSlider2.getValue());
                        this.jPanel1.add((Component)io, 0);
                        this.dm.addElement(line);
                        io.setOpaque(false);
                        io.setVisible(true);
                        this.imgpanels.add(io);
                    }
                    catch (NumberFormatException ne) {
                        JOptionPane.showMessageDialog(this, "NumberFormatException occured. Bah. Ignoring this line (Line Number: " + lnr + ")! Input string: [" + line + "]. Exception message: " + ne.getMessage());
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                        JOptionPane.showMessageDialog(this, "ArrayIndexOutOfBoundException occured. This probably means your .ani file is bugged. Ignoring this line (Line Number: " + lnr + "). Line: [" + line + "]. Exception message: " + ae.getMessage());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "SOMETHING WENT WRONG THAT THE AUTHOR OF THIS TOOL DIDN'T BOTHER CATCHING! Ignoring this line (Line Number: " + lnr + "): [" + line + "] Message: " + e.getMessage());
                    }
                }
            }
            prevline = line;
        }
        this.hotspot = this.generateHotspot(100, 100, this.jSlider2.getValue());
        this.jPanel1.add((Component)this.hotspot, 0);
        this.imgpanels.add(this.hotspot);
        if (!negativeFound) {
            int xoff = (int)((double)this.jPanel1.getWidth() * 0.5);
            int yoff = (int)((double)this.jPanel1.getHeight() * 0.5);
            for (ImagePanel i : this.imgpanels) {
                Point p = i.getLocation();
                i.setLocation((int)(p.getX() + (double)xoff), (int)(p.getY() + (double)yoff));
            }
        }
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jButton3 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jCheckBox2 = new JCheckBox();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jLabel4 = new JLabel();
        this.jButton6 = new JButton();
        this.jCheckBox3 = new JCheckBox();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(3);
        this.setTitle("UQMAnimationTool v0.3");
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(0));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 892, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 399, Short.MAX_VALUE));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setText("Start/Stop autoloop");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Rate: 50");
        this.jSlider1.setMajorTickSpacing(100);
        this.jSlider1.setMaximum(1000);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setMinorTickSpacing(25);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel2.setText("Loaded: None");
        this.jButton3.setText("Reload current file");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Ignore Duplicates (on load)");
        this.jLabel3.setText("Zoom: 3");
        this.jSlider2.setMajorTickSpacing(5);
        this.jSlider2.setMaximum(10);
        this.jSlider2.setMinimum(1);
        this.jSlider2.setMinorTickSpacing(1);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setSnapToTicks(true);
        this.jSlider2.setValue(3);
        this.jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.jSlider2StateChanged(evt);
            }
        });
        this.jCheckBox2.setText("Show only selected image");
        this.jButton4.setText("HELP/NOTES");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("Load file");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Click and drag anywhere in the blank spots of the rendering area above to drag the rendered animation around");
        this.jButton6.setText("Set Hotspot color");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton6ActionPerformed(evt);
            }
        });
        this.jCheckBox3.setSelected(true);
        this.jCheckBox3.setText("Show hotspot");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSlider2, -2, 282, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE)).addComponent(this.jSlider1, GroupLayout.Alignment.LEADING, -2, 282, -2).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButton1, -2, 279, -2).addGap(3, 3, 3)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 247, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 282, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox3))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 523, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addGap(7, 7, 7).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4)).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jCheckBox1).addComponent(this.jButton3).addComponent(this.jButton4).addComponent(this.jButton5).addComponent(this.jButton6)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox2).addComponent(this.jCheckBox3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(7, 7, 7).addComponent(this.jSlider2, -2, -1, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.toggleTimer();
    }

    private void toggleTimer() {
        if (!this.timon) {
            this.tim = new Timer();
            this.t = new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (MainFrame.this.jList1.getSelectedIndex() < MainFrame.this.dm.getSize() - 1) {
                            MainFrame.this.jList1.setSelectedIndex(MainFrame.this.jList1.getSelectedIndex() + 1);
                        } else {
                            MainFrame.this.jList1.setSelectedIndex(0);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            this.tim.scheduleAtFixedRate(this.t, 0L, (long)this.jSlider1.getValue());
            this.timon = true;
        } else {
            this.tim.cancel();
            this.timon = false;
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.jLabel1.setText("Rate: " + this.jSlider1.getValue());
        if (this.timon) {
            this.toggleTimer();
            this.toggleTimer();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        boolean oldtimon = this.timon;
        if (this.timon) {
            this.toggleTimer();
        }
        try {
            this.parseFile(this.editingFile);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (oldtimon) {
            this.toggleTimer();
        }
    }

    private void jSlider2StateChanged(ChangeEvent evt) {
        try {
            this.jLabel3.setText("Zoom: " + this.jSlider2.getValue());
            this.mu.acquire();
            this.jPanel1.removeAll();
            ArrayList<ImagePanel> newimgpanels = new ArrayList<ImagePanel>();
            boolean negativefound = false;
            int xoff = (int)((double)this.jPanel1.getWidth() * 0.5);
            int yoff = (int)((double)this.jPanel1.getHeight() * 0.5);
            for (ImagePanel i : this.imgpanels) {
                if (i.getXoff() >= 0 && i.getYoff() >= 0) continue;
                negativefound = true;
            }
            for (ImagePanel i : this.imgpanels) {
                ImagePanel j = new ImagePanel(i.getImage(), i.getXoff(), i.getYoff(), this.jSlider2.getValue());
                this.jPanel1.add((Component)j, 0);
                j.setOpaque(false);
                j.setVisible(true);
                newimgpanels.add(j);
                if (i.equals(this.hotspot)) {
                    this.hotspot = j;
                }
                if (!negativefound) continue;
                j.setLocation((int)(j.getLocation().getX() + (double)xoff), (int)(j.getLocation().getY() + (double)yoff));
            }
            this.imgpanels.clear();
            this.imgpanels = newimgpanels;
            this.jPanel1.updateUI();
            this.mu.release();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        new Notes((Frame)this, true).setVisible(true);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.timon) {
            this.tim.cancel();
            this.timon = false;
        }
        this.initMain();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Choose a color for the hotspot pixel", this.hotspotColor);
        if (c != null) {
            this.settings.hotspotColor = this.hotspotColor = c;
            this.hotspot.getImage().setRGB(0, 0, this.hotspotColor.getRGB());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseMotionListener myml;

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.myml = new MyMouseMotionListener(e.getXOnScreen(), e.getYOnScreen());
                MainFrame.this.jPanel1.addMouseMotionListener(this.myml);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MainFrame.this.jPanel1.removeMouseMotionListener(this.myml);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private int prevx = 0;
        private int prevy = 0;

        public MyMouseMotionListener(int mousestart_x, int mousestart_y) {
            this.prevx = mousestart_x;
            this.prevy = mousestart_y;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int xoff = e.getXOnScreen() - this.prevx;
            int yoff = e.getYOnScreen() - this.prevy;
            for (ImagePanel i : MainFrame.this.imgpanels) {
                Point p = i.getLocation();
                i.setLocation((int)(p.getX() + (double)xoff), (int)(p.getY() + (double)yoff));
            }
            MainFrame.this.jPanel1.updateUI();
            this.prevx = e.getXOnScreen();
            this.prevy = e.getYOnScreen();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

