package uqmanimationtool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImagePanel extends JPanel {

    private String imagepath;
    public BufferedImage image;
    int xoff, yoff;

    public ImagePanel(BufferedImage bufferedImage, int xoff, int yoff, int zoom) {
        this.imagepath = null;
        doImageContructorStuff(bufferedImage, xoff, yoff, zoom);
    }

    public ImagePanel(final String imagepath, int xoff, int yoff, int zoom) throws IOException, NoSuchAlgorithmException {
        this.imagepath = imagepath;
        doImageContructorStuff(ImageIO.read(new File(this.imagepath)), xoff, yoff, zoom);
    }
    
    private void doImageContructorStuff(BufferedImage bufferedImage, int xoff, int yoff, int zoom) {
        this.image = bufferedImage;
        setOpaque(true);
        setSize(this.image.getWidth() * zoom, this.image.getHeight() * zoom);
        this.setVisible(true);
        this.setLayout(null);
        this.xoff = xoff;
        this.yoff = yoff;
        this.setLocation(this.xoff * zoom, this.yoff * zoom);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        dopaint(g);
    }

    private void dopaint(Graphics g) {
        g.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), this);
        //System.err.println("Refresh at " + System.currentTimeMillis());
    }

    public String getImagepath() {
        return imagepath;
    }

    public int getXoff() {
        return xoff;
    }

    public int getYoff() {
        return yoff;
    }

    @Override
    public String toString() {
        return "[" + imagepath + " -- " + xoff + " -- " + yoff + "]";
    }

    public BufferedImage getImage() {
        return image;
    }
    
    
}
