/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainFrame.java
 *
 * Created on 9-okt-2010, 23:35:12
 */
package uqmanimationtool;

import com.sun.corba.se.impl.orbutil.concurrent.Mutex;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 *
 * @author joris
 */
public class MainFrame extends javax.swing.JFrame {

    Mutex mu = new Mutex();
    DefaultListModel dm = new DefaultListModel();
    ArrayList<ImagePanel> imgpanels = new ArrayList<ImagePanel>();
    Color hotspotColor = Color.red;
    ImagePanel hotspot;
    TimerTask t;
    Timer tim;
    boolean timon = false;
    File editingFile;
    Settings settings;
    XStream xstream;
    private static final String CONFFILE = "uqmanimationtool.conf";
    private int mousestart_x, mousestart_y;
    private int mousestart_loc_x, mousestart_loc_y;

    /** Creates new form MainFrame */
    public MainFrame() {
        initComponents();
        try {
            initSettings();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        initMain();

        jList1.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                try {
                    if (jList1.getSelectedIndex() != -1) {
                        mu.acquire();
                        if (jCheckBox2.isSelected()) {
                            for (ImagePanel i : imgpanels) {
                                i.setVisible(false);
                            }
                        }
                        try {
                            jPanel1.setComponentZOrder(imgpanels.get(jList1.getSelectedIndex()), 0);
                            imgpanels.get(jList1.getSelectedIndex()).setVisible(true);
                            if (jCheckBox3.isSelected()) {
                                hotspot.setVisible(true);
                                jPanel1.setComponentZOrder(hotspot, 0);
                            } else {
                                hotspot.setVisible(false);
                            }
                            jPanel1.updateUI();
                        } catch (IllegalArgumentException ex) {
                            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        mu.release();
                    }
                } catch (InterruptedException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        tim = new Timer();

        jPanel1.addMouseListener(new MyMouseListener());

        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent e) {
                FileWriter fo = null;
                try {
                    settings.hideDupe = jCheckBox1.isSelected();
                    settings.showOnlySelected = jCheckBox2.isSelected();
                    String xml = xstream.toXML(settings);
                    fo = new FileWriter(CONFFILE);
                    fo.write(xml);
                    fo.close();
                    System.exit(0);
                } catch (IOException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                } finally {
                    try {
                        fo.close();
                    } catch (IOException ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
    }

    private ImagePanel generateHotspot(int width, int height, int zoom) {
        BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        bi.setRGB(0, 0, hotspotColor.getRGB());
        ImagePanel ip = new ImagePanel(bi, 0, 0, zoom);
        ip.setVisible(true);
        ip.setOpaque(false);
        return ip;
    }

    private void initSettings() throws FileNotFoundException, IOException {
        settings = new Settings();
        xstream = new XStream(new DomDriver()); // does not require XPP3 library
        xstream.alias("UQMAnimationToolSettings", Settings.class);
        File f = new File(CONFFILE);
        if (f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            settings = (Settings) xstream.fromXML(fis);
            fis.close();
        }
        jCheckBox1.setSelected(settings.hideDupe);
        jCheckBox2.setSelected(settings.showOnlySelected);
        hotspotColor = (settings.hotspotColor == null ? Color.red : settings.hotspotColor);
    }

    public void initMain() {
        try {
            initStuffs();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "SOMETHING WENT HORRIBLY WRONG ON INITIALIZING: " + e.toString());
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    private void initStuffs() throws FileNotFoundException, NoSuchAlgorithmException {
        try {
            JFileChooser fc = new JFileChooser(settings.lastDirPath);
            fc.addChoosableFileFilter(new FileNameExtensionFilter("ani file", "ani", "med", "big", "sml"));
            int returnval = fc.showOpenDialog(this);
            jList1.setModel(dm);
            dm.clear();
            if (returnval == JFileChooser.APPROVE_OPTION) {
                editingFile = fc.getSelectedFile();
                parseFile(editingFile);
            } else {
                JOptionPane.showMessageDialog(this, "No file selected. Quitting.");
                this.dispose();
                System.exit(0);
            }

        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void parseFile(File f) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        settings.lastDirPath = f.getParent();
        jPanel1.removeAll();
        imgpanels.clear();
        dm.clear();
        jLabel2.setText("Loaded: " + f.getAbsolutePath() + " at " + System.currentTimeMillis());
        System.err.println(f.getParent());
        BufferedReader br = new BufferedReader(new FileReader(f));
        String prevline = "";
        int lnr = 0;
        boolean negativeFound = false;
        while (br.ready()) {
            lnr++;
            String line = br.readLine();
            if (!line.startsWith("#")) {
                String[] splitted = null;
                if (!jCheckBox1.isSelected() || (jCheckBox1.isSelected() && !line.equals(prevline))) {
                    try {
                        splitted = line.split(" ");
                        String fname = f.getParent() + "\\" + splitted[0];
                        int xoff = Integer.valueOf(splitted[3]);
                        int yoff = Integer.valueOf(splitted[4]);
                        if (xoff < 0 || yoff < 0) {
                            negativeFound = true;
                        }
                        xoff *= -1;
                        yoff *= -1;
                        ImagePanel io = new ImagePanel(fname, xoff, yoff, jSlider2.getValue());
                        jPanel1.add(io, 0);
                        dm.addElement(line);
                        io.setOpaque(false);
                        io.setVisible(true);
                        imgpanels.add(io);
                    } catch (NumberFormatException ne) {
                        JOptionPane.showMessageDialog(this, "NumberFormatException occured. Bah. Ignoring this line (Line Number: " + lnr + ")! Input string: [" + line + "]. Exception message: " + ne.getMessage());
                    } catch (ArrayIndexOutOfBoundsException ae) {
                        JOptionPane.showMessageDialog(this, "ArrayIndexOutOfBoundException occured. This probably means your .ani file is bugged. Ignoring this line (Line Number: " + lnr + "). Line: [" + line + "]. Exception message: " + ae.getMessage());
                    } catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "SOMETHING WENT WRONG THAT THE AUTHOR OF THIS TOOL DIDN'T BOTHER CATCHING! Ignoring this line (Line Number: " + lnr + "): [" + line + "] Message: " + e.getMessage());
                    }
                }
            }
            prevline = line;
        }
        this.hotspot = generateHotspot(100, 100, jSlider2.getValue());
        jPanel1.add(hotspot, 0);
        this.imgpanels.add(this.hotspot);
        if (!negativeFound) {
            int xoff = (int) (jPanel1.getWidth() * 0.5);
            int yoff = (int) (jPanel1.getHeight() * 0.5);
            for (ImagePanel i : imgpanels) {
                Point p = i.getLocation();
                i.setLocation((int) (p.getX() + xoff), (int) (p.getY() + yoff));
            }
        }
    }

    private class MyMouseMotionListener implements MouseMotionListener {

        private int prevx = 0, prevy = 0;

        public MyMouseMotionListener(int mousestart_x, int mousestart_y) {
            this.prevx = mousestart_x;
            this.prevy = mousestart_y;
        }

        public void mouseDragged(MouseEvent e) {
            int xoff = e.getXOnScreen() - this.prevx;
            int yoff = e.getYOnScreen() - this.prevy;
            for (ImagePanel i : imgpanels) {
                Point p = i.getLocation();
                i.setLocation((int) (p.getX() + xoff), (int) (p.getY() + yoff));
            }
            jPanel1.updateUI();
            this.prevx = e.getXOnScreen();
            this.prevy = e.getYOnScreen();
            //setLocation((e.getXOnScreen() - mousestart_x) + mousestart_loc_x, (e.getYOnScreen() - mousestart_y) + mousestart_loc_y);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class MyMouseListener implements MouseListener {

        private MyMouseMotionListener myml;

        public MyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == e.BUTTON1) { //left mouse button
                myml = new MyMouseMotionListener(e.getXOnScreen(), e.getYOnScreen());
                jPanel1.addMouseMotionListener(myml);
            }
        }

        public void mouseReleased(MouseEvent e) {
            jPanel1.removeMouseMotionListener(myml);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton2 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jCheckBox1 = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        jSlider2 = new javax.swing.JSlider();
        jCheckBox2 = new javax.swing.JCheckBox();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        jButton6 = new javax.swing.JButton();
        jCheckBox3 = new javax.swing.JCheckBox();

        jButton2.setText("jButton2");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("UQMAnimationTool v0.3");

        jPanel1.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 892, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 399, Short.MAX_VALUE)
        );

        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(jList1);

        jButton1.setText("Start/Stop autoloop");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel1.setText("Rate: 50");

        jSlider1.setMajorTickSpacing(100);
        jSlider1.setMaximum(1000);
        jSlider1.setMinimum(1);
        jSlider1.setMinorTickSpacing(25);
        jSlider1.setPaintTicks(true);
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });

        jLabel2.setText("Loaded: None");

        jButton3.setText("Reload current file");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("Ignore Duplicates (on load)");

        jLabel3.setText("Zoom: 3");

        jSlider2.setMajorTickSpacing(5);
        jSlider2.setMaximum(10);
        jSlider2.setMinimum(1);
        jSlider2.setMinorTickSpacing(1);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(true);
        jSlider2.setValue(3);
        jSlider2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider2StateChanged(evt);
            }
        });

        jCheckBox2.setText("Show only selected image");

        jButton4.setText("HELP/NOTES");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jButton5.setText("Load file");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });

        jLabel4.setText("Click and drag anywhere in the blank spots of the rendering area above to drag the rendered animation around");

        jButton6.setText("Set Hotspot color");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });

        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Show hotspot");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, 282, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addComponent(jLabel1)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE))
                                .addComponent(jSlider1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 282, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 279, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGap(3, 3, 3))
                                .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                    .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 247, Short.MAX_VALUE))
                                .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 282, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jCheckBox2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBox3)))
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(2, 2, 2)
                        .addComponent(jButton5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 523, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jCheckBox1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton3)
                        .addGap(7, 7, 7)
                        .addComponent(jButton6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton4))
                    .addComponent(jLabel4, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jCheckBox1)
                    .addComponent(jButton3)
                    .addComponent(jButton4)
                    .addComponent(jButton5)
                    .addComponent(jButton6))
                .addGap(7, 7, 7)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 217, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox2)
                            .addComponent(jCheckBox3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3)
                        .addGap(7, 7, 7)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel4))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        toggleTimer();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void toggleTimer() {
        if (!timon) {
            tim = new Timer();
            t = new TimerTask() {

                @Override
                public void run() {
                    try {
                        //mu.acquire();
                        if (jList1.getSelectedIndex() < dm.getSize() - 1) {
                            jList1.setSelectedIndex(jList1.getSelectedIndex() + 1);
                        } else {
                            jList1.setSelectedIndex(0);
                        }
                        //mu.release();
                        //} catch (InterruptedException ex) {
                        //    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    } catch (IllegalArgumentException ex) {
                        Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            tim.scheduleAtFixedRate(t, 0, jSlider1.getValue());
            timon = true;
        } else {
            tim.cancel();
            timon = false;
        }
    }

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        jLabel1.setText("Rate: " + jSlider1.getValue());
        if (timon) {
            toggleTimer();
            toggleTimer();
        }
    }//GEN-LAST:event_jSlider1StateChanged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        boolean oldtimon = timon;
        if (timon) {
            toggleTimer();
        }
        try {
            parseFile(editingFile);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        } catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (oldtimon) {
            toggleTimer();
        }
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jSlider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider2StateChanged
        try {
            jLabel3.setText("Zoom: " + jSlider2.getValue());
            mu.acquire();
            jPanel1.removeAll();
            ArrayList<ImagePanel> newimgpanels = new ArrayList<ImagePanel>();

            boolean negativefound = false;
            int xoff = (int) (jPanel1.getWidth() * 0.5);
            int yoff = (int) (jPanel1.getHeight() * 0.5);
            for (ImagePanel i : imgpanels) {
                if (i.getXoff() < 0 || i.getYoff() < 0) {
                    negativefound = true;
                }
            }

            for (ImagePanel i : imgpanels) {
                //
                ImagePanel j = new ImagePanel(i.getImage(), i.getXoff(), i.getYoff(), jSlider2.getValue());
                jPanel1.add(j, 0);
                j.setOpaque(false);
                j.setVisible(true);
                newimgpanels.add(j);
                //j.setLocation(i.getLocation());
                if (i.equals(hotspot)) {
                    hotspot = j;
                }
                if (negativefound) {
                    j.setLocation((int) (j.getLocation().getX() + xoff), (int) (j.getLocation().getY() + yoff));
                }
            }
            imgpanels.clear();
            imgpanels = newimgpanels;
            jPanel1.updateUI();
            mu.release();
        } catch (InterruptedException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_jSlider2StateChanged
    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        new Notes(this, true).setVisible(true);
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        if (timon) {
            tim.cancel();
            timon = false;
        }
        initMain();
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        Color c = JColorChooser.showDialog(this, "Choose a color for the hotspot pixel", hotspotColor);
        if (c != null) {
            hotspotColor = c;
            settings.hotspotColor = hotspotColor;
            hotspot.getImage().setRGB(0, 0, hotspotColor.getRGB());
        }
    }//GEN-LAST:event_jButton6ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JCheckBox jCheckBox2;
    private javax.swing.JCheckBox jCheckBox3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    // End of variables declaration//GEN-END:variables
}
