/*
 * Decompiled with CFR 0.152.
 */
package uqmconversation.GUIElements;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uqmconversation.GUIElements.ConvoOptionEditor;
import uqmconversation.GUIElements.StatementEditor;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoNode;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Statement;

public class ConvoNodeEditor
extends JDialog {
    private static int BUTTONHEIGHT = 30;
    private Conversation convo;
    private ConvoNode convoNode;
    private Frame parent;
    private JButton btAddCon;
    private JButton btAddStatement;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel pnlStuff;
    private JTextField tbNodeName;

    public ConvoNodeEditor(Frame parent, ConvoNode convn, Conversation convo) {
        super(parent, true);
        this.initComponents();
        this.convoNode = convn;
        this.convo = convo;
        this.parent = parent;
        this.redraw();
        this.tbNodeName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ConvoNodeEditor.this.convoNode.setName(ConvoNodeEditor.this.tbNodeName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                ConvoNodeEditor.this.convoNode.setName(ConvoNodeEditor.this.tbNodeName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                ConvoNodeEditor.this.convoNode.setName(ConvoNodeEditor.this.tbNodeName.getText());
            }
        });
    }

    public ConvoNode getConvoNode() {
        return this.convoNode;
    }

    private void redraw() {
        JButton statB;
        this.pnlStuff.removeAll();
        this.tbNodeName.setText(this.convoNode.getName());
        int locY = 0;
        for (ConvoOption co : this.convoNode.getOptions()) {
            statB = new JButton("<html><b>" + co.getZelnickResponsestatement() + "</b> to <i>" + co.getAlienPhrases() + "</i> -- func: <i>" + co.getNextFunction().getName() + "</i></html>");
            statB.addActionListener(new myActionListener(co, statB, this.convo));
            statB.setSize(this.pnlStuff.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            this.pnlStuff.add(statB);
            locY += BUTTONHEIGHT;
        }
        for (Statement stat : this.convoNode.getStatements()) {
            statB = new JButton(stat.render());
            statB.addActionListener(new myActionListener_stat(stat, statB, this.convo));
            statB.setSize(this.pnlStuff.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            this.pnlStuff.add(statB);
            locY += BUTTONHEIGHT;
        }
        this.pnlStuff.updateUI();
    }

    private void initComponents() {
        this.pnlStuff = new JPanel();
        this.jLabel1 = new JLabel();
        this.tbNodeName = new JTextField();
        this.jLabel2 = new JLabel();
        this.btAddCon = new JButton();
        this.btAddStatement = new JButton();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Conversation Node Editor");
        this.pnlStuff.setBorder(BorderFactory.createBevelBorder(1));
        GroupLayout pnlStuffLayout = new GroupLayout(this.pnlStuff);
        this.pnlStuff.setLayout(pnlStuffLayout);
        pnlStuffLayout.setHorizontalGroup(pnlStuffLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 663, Short.MAX_VALUE));
        pnlStuffLayout.setVerticalGroup(pnlStuffLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 356, Short.MAX_VALUE));
        this.jLabel1.setText("Conversation options and any extra statements:");
        this.tbNodeName.setText("jTextField1");
        this.jLabel2.setText("Node name:");
        this.btAddCon.setText("Add conversation option");
        this.btAddCon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvoNodeEditor.this.btAddConActionPerformed(evt);
            }
        });
        this.btAddStatement.setText("Add statement");
        this.btAddStatement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvoNodeEditor.this.btAddStatementActionPerformed(evt);
            }
        });
        this.jButton1.setText("Set as entryPoint");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvoNodeEditor.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlStuff, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbNodeName, -1, 605, Short.MAX_VALUE)).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton1, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE).addComponent(this.btAddCon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btAddStatement))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tbNodeName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlStuff, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btAddStatement).addComponent(this.btAddCon).addComponent(this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void btAddConActionPerformed(ActionEvent evt) {
        ConvoOptionEditor coe = new ConvoOptionEditor(this.parent, null, this.convo);
        coe.setVisible(true);
        if (coe.getConvoOption() != null) {
            this.convoNode.addOption(coe.getConvoOption());
        } else {
            JOptionPane.showMessageDialog(null, "No conversation option added");
        }
        this.redraw();
    }

    private void btAddStatementActionPerformed(ActionEvent evt) {
        StatementEditor se = new StatementEditor(null, null, this.convo);
        se.setVisible(true);
        if (se.getStatement() != null) {
            this.convoNode.addStatement(se.getStatement());
        } else {
            JOptionPane.showMessageDialog(null, "No statement added");
        }
        this.redraw();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.convo.getCode().setEntryPoint(this.convoNode);
    }

    private class myActionListener_stat
    implements ActionListener {
        private Statement stat;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener_stat(Statement stat, JButton parentbutton, Conversation convo) {
            this.stat = stat;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            StatementEditor s = new StatementEditor(null, null, this.convo);
            s.setVisible(true);
            this.stat = s.getStatement();
            ConvoNodeEditor.this.redraw();
        }
    }

    private class myActionListener
    implements ActionListener {
        private ConvoOption copt;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener(ConvoOption copt, JButton parentbutton, Conversation convo) {
            this.copt = copt;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            ConvoOptionEditor coe = new ConvoOptionEditor(ConvoNodeEditor.this.parent, this.copt, this.convo);
            coe.setVisible(true);
            this.copt = coe.getConvoOption();
            ConvoNodeEditor.this.redraw();
        }
    }
}

