/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ConvoNodeEditor2.java
 *
 * Created on 8-okt-2010, 22:02:32
 */
package uqmconversation.GUIElements;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoNode;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Statement;

/**
 *
 * @author joris
 */
public class ConvoNodeEditor extends javax.swing.JDialog {

    private static int BUTTONHEIGHT = 30;
    private Conversation convo;
    private ConvoNode convoNode;
    private java.awt.Frame parent;

    private class myActionListener implements ActionListener {

        private ConvoOption copt;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener(ConvoOption copt, JButton parentbutton, Conversation convo) {
            this.copt = copt;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            ConvoOptionEditor coe = new ConvoOptionEditor(parent, copt, this.convo);
            coe.setVisible(true);
            copt = coe.getConvoOption();
            redraw();
        }
    }

    private class myActionListener_stat implements ActionListener {

        private Statement stat;
        private JButton parentbutton;
        private Conversation convo;

        public myActionListener_stat(Statement stat, JButton parentbutton, Conversation convo) {
            this.stat = stat;
            this.parentbutton = parentbutton;
            this.convo = convo;
        }

        public void actionPerformed(ActionEvent e) {
            StatementEditor s = new StatementEditor(null, null, convo);
            s.setVisible(true);
            stat = s.getStatement();
            redraw();
        }
    }

    /** Creates new form ConvoNodeEditor */
    public ConvoNodeEditor(java.awt.Frame parent, ConvoNode convn, Conversation convo) {
        super(parent, true);
        initComponents();
        this.convoNode = convn;
        this.convo = convo;
        this.parent = parent;
        redraw();

        this.tbNodeName.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                convoNode.setName(tbNodeName.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                convoNode.setName(tbNodeName.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                convoNode.setName(tbNodeName.getText());
            }
        });
    }

    public ConvoNode getConvoNode() {
        return convoNode;
    }

    private void redraw() {
        pnlStuff.removeAll();
        tbNodeName.setText(this.convoNode.getName());
        int locY = 0;

        for (ConvoOption co : convoNode.getOptions()) {
            JButton statB = new JButton("<html><b>" + co.getZelnickResponsestatement() + "</b> to <i>" + co.getAlienPhrases() + "</i> -- func: <i>" + co.getNextFunction().getName() + "</i></html>");
            statB.addActionListener(new myActionListener(co, statB, convo));

            statB.setSize(pnlStuff.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            pnlStuff.add(statB);
            locY += BUTTONHEIGHT;
        }

        for (final Statement stat : convoNode.getStatements()) {
            JButton statB = new JButton(stat.render());
            statB.addActionListener(new myActionListener_stat(stat, statB, convo));

            statB.setSize(pnlStuff.getWidth(), BUTTONHEIGHT);
            statB.setLocation(0, locY);
            pnlStuff.add(statB);
            locY += BUTTONHEIGHT;
        }


        pnlStuff.updateUI();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlStuff = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        tbNodeName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        btAddCon = new javax.swing.JButton();
        btAddStatement = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Conversation Node Editor");

        pnlStuff.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        javax.swing.GroupLayout pnlStuffLayout = new javax.swing.GroupLayout(pnlStuff);
        pnlStuff.setLayout(pnlStuffLayout);
        pnlStuffLayout.setHorizontalGroup(
            pnlStuffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 663, Short.MAX_VALUE)
        );
        pnlStuffLayout.setVerticalGroup(
            pnlStuffLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 356, Short.MAX_VALUE)
        );

        jLabel1.setText("Conversation options and any extra statements:");

        tbNodeName.setText("jTextField1");

        jLabel2.setText("Node name:");

        btAddCon.setText("Add conversation option");
        btAddCon.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btAddConActionPerformed(evt);
            }
        });

        btAddStatement.setText("Add statement");
        btAddStatement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btAddStatementActionPerformed(evt);
            }
        });

        jButton1.setText("Set as entryPoint");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pnlStuff, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tbNodeName, javax.swing.GroupLayout.DEFAULT_SIZE, 605, Short.MAX_VALUE))
                    .addComponent(jLabel1)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 169, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 240, Short.MAX_VALUE)
                        .addComponent(btAddCon)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btAddStatement)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(tbNodeName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnlStuff, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(1, 1, 1)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btAddStatement)
                    .addComponent(btAddCon)
                    .addComponent(jButton1))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btAddConActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btAddConActionPerformed
        ConvoOptionEditor coe = new ConvoOptionEditor(parent, null, this.convo);
        coe.setVisible(true);
        if (coe.getConvoOption() != null) {
            convoNode.addOption(coe.getConvoOption());
        } else {
            JOptionPane.showMessageDialog(null, "No conversation option added");
        }
        redraw();
}//GEN-LAST:event_btAddConActionPerformed

    private void btAddStatementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btAddStatementActionPerformed
        StatementEditor se = new StatementEditor(null, null, convo);
        se.setVisible(true);
        if (se.getStatement() != null) {
            this.convoNode.addStatement(se.getStatement());
        } else {
            JOptionPane.showMessageDialog(null, "No statement added");
        }
        redraw();
    }//GEN-LAST:event_btAddStatementActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        convo.getCode().setEntryPoint(convoNode);
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btAddCon;
    private javax.swing.JButton btAddStatement;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel pnlStuff;
    private javax.swing.JTextField tbNodeName;
    // End of variables declaration//GEN-END:variables
}
