/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ConvoOptionEditor.java
 *
 * Created on 8-okt-2010, 21:45:41
 */
package uqmconversation.GUIElements;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Dialog_Entry;
import uqmconversation.domain.Function;
import uqmconversation.domain.UQMNPCPhrase;
import uqmconversation.miscclasses.DoubleClickListener;

/**
 *
 * @author joris
 */
public class ConvoOptionEditor extends javax.swing.JDialog {

    private ConvoOption convoOption;
    private DefaultListModel dmAlien_FINAL;

    public ConvoOption getConvoOption() {
        return convoOption;
    }

    /** Creates new form ConvoOptionEditor */
    public ConvoOptionEditor(java.awt.Frame parent, ConvoOption convoOption, Conversation convo) {
        super(parent, true);
        initComponents();
        dmAlien_FINAL = new DefaultListModel();
        lbAlien_FINAL.setModel(dmAlien_FINAL);
        lbZel.setListData(convo.getZelnickEntries().toArray());
        lbAlien_SELECT.setListData(convo.getAlienEntries().toArray());
        lbFunc.setListData(convo.getCode().getFunctions().toArray());
        if (convoOption != null) {
            this.convoOption = convoOption;
            lbZel.setSelectedValue(this.convoOption.getZelnickResponsestatement().getDialogEntry(), true);
            for (UQMNPCPhrase phr : this.convoOption.getAlienPhrases()) {
                dmAlien_FINAL.addElement(phr.getDialogEntry());
            }
            lbFunc.setSelectedValue(this.convoOption.getNextFunction(), true);
            cbDisa.setSelected(convoOption.getDisablePhrase());
        } else {
            this.convoOption = null;
        }

        lbZel.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                jTextArea1.setText(((Dialog_Entry) lbZel.getSelectedValue()).dialogString);
                jTextArea1.setCaretPosition(0);
            }
        });
        lbAlien_SELECT.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                jTextArea1.setText(((Dialog_Entry) lbAlien_SELECT.getSelectedValue()).dialogString);
                jTextArea1.setCaretPosition(0);
            }
        });
        lbAlien_FINAL.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                try {
                    jTextArea1.setText(((Dialog_Entry) lbAlien_FINAL.getSelectedValue()).dialogString);
                    jTextArea1.setCaretPosition(0);
                } catch (NullPointerException ne) {
                }
            }
        });
        lbFunc.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                jTextArea1.setText(((Function) lbFunc.getSelectedValue()).render_definition());
                jTextArea1.setCaretPosition(0);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int) (screenSize.getWidth() * 0.75), (int) (screenSize.getHeight() * 0.75));

        lbAlien_SELECT.addMouseListener(new DoubleClickListener() {

            @Override
            public void doubleClicked(MouseEvent e) {
                dmAlien_FINAL.addElement(lbAlien_SELECT.getSelectedValue());
            }
        });
        lbAlien_FINAL.addMouseListener(new DoubleClickListener() {

            @Override
            public void doubleClicked(MouseEvent e) {
                dmAlien_FINAL.remove(lbAlien_FINAL.getSelectedIndex());
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lbAlien_SELECT = new javax.swing.JList();
        jScrollPane3 = new javax.swing.JScrollPane();
        lbAlien_FINAL = new javax.swing.JList();
        jLabel2 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        lbZel = new javax.swing.JList();
        cbDisa = new javax.swing.JCheckBox();
        jPanel5 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jScrollPane5 = new javax.swing.JScrollPane();
        lbFunc = new javax.swing.JList();
        jButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        setTitle("Conversation Option Editor");

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jLabel1.setText("Alien's Response (select one and double click):");

        lbAlien_SELECT.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        lbAlien_SELECT.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lbAlien_SELECTMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(lbAlien_SELECT);

        lbAlien_FINAL.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        lbAlien_FINAL.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lbAlien_FINALMouseClicked(evt);
            }
        });
        jScrollPane3.setViewportView(lbAlien_FINAL);

        jLabel2.setText("Alien's Responses:");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 224, Short.MAX_VALUE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 224, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 182, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jLabel4.setText("Zelnick's init phrase:");

        lbZel.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        lbZel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lbZelMouseClicked(evt);
            }
        });
        jScrollPane4.setViewportView(lbZel);

        cbDisa.setText("Disable afterwards");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 223, Short.MAX_VALUE)
                    .addComponent(jLabel4)
                    .addComponent(cbDisa))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 271, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbDisa)
                .addContainerGap())
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jLabel5.setText("Function to go to:");

        lbFunc.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        lbFunc.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lbFuncMouseClicked(evt);
            }
        });
        jScrollPane5.setViewportView(lbFunc);

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
                    .addComponent(jLabel5))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 292, Short.MAX_VALUE)
                .addContainerGap())
        );

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setWrapStyleWord(true);
        jScrollPane2.setViewportView(jTextArea1);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 659, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(8, 8, 8)
                        .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel5, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton1)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        if (!dmAlien_FINAL.isEmpty()) {
            ArrayList<Dialog_Entry> diaentries = new ArrayList<Dialog_Entry>();
            for (int i = 0; i < dmAlien_FINAL.getSize(); i++) {
                diaentries.add((Dialog_Entry) dmAlien_FINAL.get(i));
            }
            if (this.convoOption == null) {
                this.convoOption = new ConvoOption((Dialog_Entry) lbZel.getSelectedValue(), diaentries, (Function) lbFunc.getSelectedValue(), cbDisa.isSelected());
            } else {
                this.convoOption.refresh((Dialog_Entry) lbZel.getSelectedValue(), diaentries, (Function) lbFunc.getSelectedValue(), cbDisa.isSelected());
            }
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(rootPane, "<html>No alien dialog option added.<br> Please double-click on an item in the upper alien dialog list to add it to the phrases the alien should say.</html>");
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void lbZelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lbZelMouseClicked
        jTextArea1.setText(((Dialog_Entry) lbZel.getSelectedValue()).dialogString);
        jTextArea1.setCaretPosition(0);
    }//GEN-LAST:event_lbZelMouseClicked

    private void lbAlien_SELECTMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lbAlien_SELECTMouseClicked
        jTextArea1.setText(((Dialog_Entry) lbAlien_SELECT.getSelectedValue()).dialogString);
        jTextArea1.setCaretPosition(0);
    }//GEN-LAST:event_lbAlien_SELECTMouseClicked

    private void lbFuncMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lbFuncMouseClicked
        jTextArea1.setText(((Function) lbFunc.getSelectedValue()).render_definition());
        jTextArea1.setCaretPosition(0);
    }//GEN-LAST:event_lbFuncMouseClicked

    private void lbAlien_FINALMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lbAlien_FINALMouseClicked
        // TODO add your handling code here:
    }//GEN-LAST:event_lbAlien_FINALMouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbDisa;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JList lbAlien_FINAL;
    private javax.swing.JList lbAlien_SELECT;
    private javax.swing.JList lbFunc;
    private javax.swing.JList lbZel;
    // End of variables declaration//GEN-END:variables
}
