/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Settings {

    private HashMap<String, String> settings_Strings;
    private HashMap<String, Boolean> settings_Booleans;
    private HashMap<String, Integer> settings_Integers;
    private static final String CONFFILE = "uqmctoolsettings.conf";

    public static Settings initInstance() {
        File f = new File(CONFFILE);
        Settings retsettings = null;
        if (f.exists()) {
            XStream xstream = new XStream(new DomDriver()); // does not require XPP3 library
            try {
                retsettings = (Settings) xstream.fromXML(new FileInputStream(f));
            } catch (FileNotFoundException ex) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (retsettings == null) {
            retsettings = new Settings();
        }
        return retsettings;
    }

    private Settings() {
        settings_Strings = new HashMap<String, String>();
        settings_Booleans = new HashMap<String, Boolean>();
        settings_Integers = new HashMap<String, Integer>();
    }

    public void setSetting(String settingName, String settingValue) {
        settings_Strings.put(settingName, settingValue);
    }

    public void setSetting(String settingName, Boolean settingValue) {
        settings_Booleans.put(settingName, settingValue);
    }

    public void setSetting(String settingName, Integer settingValue) {
        settings_Integers.put(settingName, settingValue);
    }

    public String getSettingString(String settingName) {
        return settings_Strings.get(settingName);
    }

    public String getSettingString(String settingName, String default_if_null) {
        if (!settings_Strings.containsKey(settingName)) {
            return default_if_null;
        } else {
            return settings_Strings.get(settingName);
        }
    }

    public Integer getSettingInteger(String settingName) {
        return settings_Integers.get(settingName);
    }

    public Boolean getSettingBoolean(String settingName, Boolean default_if_null) {
        if (settings_Booleans.containsKey(settingName)) {
            return settings_Booleans.get(settingName);
        } else {
            return default_if_null;
        }
    }

    public void saveSettings() throws IOException {
        FileWriter fo = null;
        XStream xstream = new XStream(new DomDriver()); // does not require XPP3 library
        String xml = xstream.toXML(this);
        fo = new FileWriter(Settings.CONFFILE);
        fo.write(xml);
        fo.close();
    }
}
