/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainFrame.java
 *
 * Created on 3-okt-2010, 21:52:35
 */
package uqmconversation;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uqmconversation.GUIElements.ConversationSim;
import uqmconversation.GUIElements.ConvoNodePanel;
import uqmconversation.GUIElements.FunctionPanel;
import uqmconversation.GUIElements.TextEditor;
import uqmconversation.domain.Conversation;
import uqmconversation.domain.ConvoNode;
import uqmconversation.domain.ConvoOption;
import uqmconversation.domain.Dialog_Entry;
import uqmconversation.domain.Function;
import uqmconversation.domain.Statement;
import uqmconversation.domain.UQMCustomCode;
import uqmconversation.domain.UQMDisableResponse;
import uqmconversation.domain.UQMFunctionCall;
import uqmconversation.domain.UQMNPCPhrase;
import uqmconversation.domain.UQMZelnickResponse;
import uqmconversation.filestuff.AbstractFile;
import uqmconversation.filestuff.DialogParser;
import uqmconversation.filestuff.FileList;

/**
 *
 * @author joris
 */
public class UQMConversationTool extends javax.swing.JFrame {

    //Static strings/objects:
    public static final String TOOL_NAME_VERSION = "UQMConversationTool v0.03";
    public static Settings TOOLSETTINGS;
    //GUI stuff:
    private ArrayList<JPanel> panels;
    //Various:
    private Conversation convo;
    private FileList filelist;
    //Editing entry, settings:
    private Dialog_Entry editingEntry;
    private Dialog_Entry.E_dialogType editingFromList;
    private boolean editingNew = true;

    private static XStream XSTREAM;


    /** Creates new form MainFrame */
    public UQMConversationTool() {
        try {
            ///Settings loading/parsing/stuffing:
            init_parseSettings();

            //Set native look & feel if needed (this has to be done PRIOR to initComponents)
            try {
                if (TOOLSETTINGS.getSettingBoolean("INTERFACE_nativelookandfeel", false)) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } catch (Exception ex) {
                Logger.getLogger(UQMConversationTool.class.getName()).log(Level.WARNING, null, ex);
            }

            //Initialzie components of this form (generated code follows)
            initComponents();

            //Set GUI elements based on settings
            getSettings();

            //Initialize members:
            panels = new ArrayList<JPanel>();
            convo = null;
            filelist = new FileList();

            //Set GUI stuff:
            init_setGUI();

            //Set XSream stuff
            XSTREAM = new XStream(new DomDriver()); // does not require XPP3 library
            XSTREAM.autodetectAnnotations(true);
            XSTREAM.alias("CONVERSATION", Conversation.class);
            XSTREAM.alias("UQMNPCPhrase", UQMNPCPhrase.class);
            XSTREAM.alias("UQMFunctionCall", UQMFunctionCall.class);
            XSTREAM.alias("UQMCustomCode", UQMCustomCode.class);
            XSTREAM.alias("UQMZelnickResponse", UQMZelnickResponse.class);
            XSTREAM.alias("UQMDisableResponse", UQMDisableResponse.class);
            XSTREAM.alias("convoNode", ConvoNode.class);
            XSTREAM.alias("convoOption", ConvoOption.class);
            XSTREAM.alias("dialogEntry", Dialog_Entry.class);
            XSTREAM.alias("Statement", Statement.class);

        } catch (Exception ex) {  //Pokemon exception handling.. ;)
            messageDialogLog(ex);
            Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void init_parseSettings() {
        TOOLSETTINGS = Settings.initInstance();
        addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    pushSettings();
                    TOOLSETTINGS.saveSettings();
                    System.exit(0);
                } catch (IOException ex) {
                    JOptionPane.showMessageDialog(rootPane, "Settings not saved. Sorry! :(");
                    Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
                }

            }
        });
    }

    /**
     * Refresh the GUI based on the settings retrieved
     */
    private void getSettings() {
        setting_NativeLF.setSelected(TOOLSETTINGS.getSettingBoolean("INTERFACE_nativelookandfeel", false));
        setting_rerouteSystemouts.setSelected(TOOLSETTINGS.getSettingBoolean("INTERFACE_rerouteSystemOuts", true));
        if (TOOLSETTINGS.getSettingString("UQMVERSION", "UQM").equals("UQM")) {
            TSuqmversionUQM.setSelected(true);
        } else if (TOOLSETTINGS.getSettingString("UQMVERSION", "UQM").equals("P6014")) {
            TSuqmversionp6014.setSelected(true);
        }
        if (TOOLSETTINGS.getSettingBoolean("INTERFACE_rerouteSystemOuts", true)) {
            System.setErr(new PrintStream(new OutputStream() {

                @Override
                public void write(int b) throws IOException {
                    CONSOLE_err.append("" + (char) b);
                }
            }));

            System.setOut(new PrintStream(new OutputStream() {

                @Override
                public void write(int b) throws IOException {
                    CONSOLE_out.append("" + (char) b);
                }
            }));
        }
    }

    /*
     * Push all settings back to the Settings object (retrieve them from the GUI, etc)
     */
    private void pushSettings() {
        TOOLSETTINGS.setSetting("INTERFACE_nativelookandfeel", setting_NativeLF.isSelected());
        TOOLSETTINGS.setSetting("INTERFACE_rerouteSystemOuts", setting_rerouteSystemouts.isSelected());
        //TSuqmversionUQM and TSuqmversionP6014 are set upon change.
    }

    private int parseDialogFile(BufferedReader br) {
        int cleartype = 0;
        if (convo.getDialogEntries().size() > 0) {
            cleartype = JOptionPane.showOptionDialog(rootPane, "<html>You're trying to import a dialog text file to the current conversation.<br>...unfortunately we already have a few entries in our conversation.<br>This means that collisions may occur between the current enties and the ones from the file to be loaded.<br>Please specify what should happen now.</html>", "POSSIBLE DIALOG COLLISIONS", JOptionPane.DEFAULT_OPTION, JOptionPane.QUESTION_MESSAGE, null, new String[]{"Clear all dialog entries in the current conversation", "Overwrite colliding dialog entries with the entry from the file", "Keep any colliding dialog entries; ignore the entry from the file"}, null);
        }
        return DialogParser.parseDialogfile(br, convo, cleartype);
    }

    private void init_refreshDialogFileList() {
        Cdd_dialogFilelist.setModel(new DefaultComboBoxModel(new Vector<AbstractFile>(filelist.getFilelist())));
        Cdd_dialogFilelist.insertItemAt("", 0);
        Cdd_dialogFilelist.setSelectedItem("");
    }

    private void init_setGUI() {
        this.setExtendedState(this.getExtendedState() | this.MAXIMIZED_BOTH); //Maximize the window on startup
        setTitle(TOOL_NAME_VERSION);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE); //Set tooltips to stay indefinitely

        init_refreshDialogFileList();
        Cdd_dialogFilelist.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                if (convo != null) {
                    if (Cdd_dialogFilelist.getSelectedIndex() != 0) {
                        AbstractFile af = (AbstractFile) Cdd_dialogFilelist.getSelectedObjects()[0];
                        int parsed = 0;
                        try {
                            parsed = parseDialogFile(af.getBufferedReader());
                        } catch (IOException ex) {
                            Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        list_AlienD.updateUI();
                        list_ZelnickD.updateUI();
                        Cdd_dialogFilelist.setSelectedIndex(0);
                        Cdd_dialogFilelist.updateUI();
                        JOptionPane.showMessageDialog(rootPane, "Added " + parsed + " dialog entries! - Now got " + convo.getDialogEntries().size() + " entries in total!");
                    }
                }
            }
        });

        MainTabs.addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                if (convo == null && MainTabs.getSelectedIndex() != 0 && MainTabs.getSelectedIndex() != 1 && MainTabs.getSelectedIndex() != MainTabs.getTabCount() - 1) {
                    JOptionPane.showMessageDialog(rootPane, "No project loaded. Please load a project first, or start a new one!");
                }
            }
        });

        //Dialog String editor:
        list_AlienD.setModel(new ListModel() {

            public int getSize() {
                if (convo == null) {
                    return 0;
                }
                return convo.getAlienEntries().size();
            }

            public Object getElementAt(int index) {
                if (convo == null) {
                    return null;
                }
                return convo.getAlienEntries().get(index);
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        list_ZelnickD.setModel(new ListModel() {

            public int getSize() {
                if (convo == null) {
                    return 0;
                }
                return convo.getZelnickEntries().size();
            }

            public Object getElementAt(int index) {
                if (convo == null) {
                    return null;
                }
                return convo.getZelnickEntries().get(index);
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        });
        list_AlienD.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (list_AlienD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry) list_AlienD.getSelectedValue();
                    setEditing(temp, Dialog_Entry.E_dialogType.alien, false);

                    list_ZelnickD.clearSelection();
                    list_ZelnickD.updateUI();
                }
            }
        });
        list_ZelnickD.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                if (list_ZelnickD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry) list_ZelnickD.getSelectedValue();
                    setEditing(temp, Dialog_Entry.E_dialogType.zelnick, false);

                    list_AlienD.clearSelection();
                    list_AlienD.updateUI();
                }
            }
        });

        KeyListener keyl = new KeyListener() { //This might not be all that nice if the UI does not throw key events... or something...

            public void keyTyped(KeyEvent e) {
                if (pnl_Right.getBackground() == SystemColor.yellow || pnl_Right.getBackground() == SystemColor.orange) {
                    pnl_Right.setBackground(SystemColor.orange);
                } else {
                    pnl_Right.setBackground(SystemColor.red);
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        };


        text_rp_filename.addKeyListener(keyl);
        text_rp_identifier.addKeyListener(keyl);
        textarea_rp_dialogString.addKeyListener(keyl);

        hideShowStuff_convo();
    }

    /**
     * Hide and show stuff based on if we are editing a conversation
     */
    public void hideShowStuff_convo() {
        if (convo == null) { //Hide stuff
            hideShowStuff_convo_dohide(false);
            PSettings_projfilelabel.setText("No project loaded");
        } else { //Show stuff
            hideShowStuff_convo_dohide(true);
            PSettings_projfilelabel.setText("Project loaded: [TODO FILL THIS IN]"); //TODO: do this.
            pnl_Right.setVisible(false);
        }
    }

    /**
     * Hide and show stuff based on if we are editing a conversation
     */
    public void hideShowStuff_convo_dohide(boolean showstuff) {
        PSettings_DialogFilePNL.setVisible(showstuff);
        PSettings_FileGeneration.setVisible(showstuff);
        Cbt_saveproj.setVisible(showstuff);
        MainTabs.setEnabledAt(2, showstuff);
        MainTabs.setEnabledAt(3, showstuff);

        for (int i = 2; i < MainTabs.getTabCount() - 1; i++) {
            Component tc = MainTabs.getComponentAt(i);
            if (tc != null) {
                if (tc.getClass() == JPanel.class) {
                    JPanel p = (JPanel) tc;
                    for (Component c : p.getComponents()) {
                        c.setVisible(showstuff);
                    }
                } else if (tc.getClass() == JSplitPane.class) {
                    JSplitPane p = (JSplitPane) tc;
                    for (Component c : p.getComponents()) {
                        c.setVisible(showstuff);
                    }
                }
            }
        }
    }

    public void messageDialogLog(Exception ex) {
        JOptionPane.showMessageDialog(rootPane, "<HTML>Some error occured. Bummer.<BR" + ex.getMessage() + "<BR><PRE>" + ex.toString() + "</PRE></HTML>");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        MainTabs = new javax.swing.JTabbedPane();
        MainPanel_ToolSettings = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        TSuqmversionUQM = new javax.swing.JRadioButton();
        TSuqmversionp6014 = new javax.swing.JRadioButton();
        jLabel9 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        setting_NativeLF = new javax.swing.JCheckBox();
        setting_rerouteSystemouts = new javax.swing.JCheckBox();
        MainPanel_ProjectSettings = new javax.swing.JPanel();
        PSettings_DialogFilePNL = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        Cdd_dialogFilelist = new javax.swing.JComboBox();
        jLabel13 = new javax.swing.JLabel();
        jButton2 = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        Cbt_loadproj = new javax.swing.JButton();
        Cbt_loadproj1 = new javax.swing.JButton();
        Cbt_saveproj = new javax.swing.JButton();
        jLabel14 = new javax.swing.JLabel();
        PSettings_projfilelabel = new javax.swing.JLabel();
        PSettings_FileGeneration = new javax.swing.JPanel();
        btn_Save = new javax.swing.JButton();
        Cbt_genCode = new javax.swing.JButton();
        Cbt_genStringsh = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        MainPanel_ConvEd = new javax.swing.JPanel();
        Cpnl_left = new javax.swing.JPanel();
        Cbt_newCNode = new javax.swing.JButton();
        Cbt_newFunction = new javax.swing.JButton();
        Bt_help = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        Cpnl_right = new javax.swing.JPanel();
        MainPanel_textEd = new javax.swing.JPanel();
        pnl_Left = new javax.swing.JPanel();
        pnl_Left_Inner = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        list_AlienD = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        list_ZelnickD = new javax.swing.JList();
        bt_lp_newAlien = new javax.swing.JButton();
        bt_lp_newZelnick = new javax.swing.JButton();
        btn_Help = new javax.swing.JButton();
        pnl_Right = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        textarea_rp_dialogString = new javax.swing.JTextArea();
        btn_rp_Save = new javax.swing.JButton();
        btn_rp_Cancel = new javax.swing.JButton();
        text_rp_identifier = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        text_rp_filename = new javax.swing.JTextField();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel2 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        CONSOLE_out = new javax.swing.JTextArea();
        jPanel3 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        jScrollPane7 = new javax.swing.JScrollPane();
        CONSOLE_err = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Text Editor");

        MainTabs.setPreferredSize(preferredSize());

        MainPanel_ToolSettings.setPreferredSize(MainTabs.preferredSize());

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        buttonGroup1.add(TSuqmversionUQM);
        TSuqmversionUQM.setText("UQM 0.6.* (or below? and above?)");
        TSuqmversionUQM.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                TSuqmversionUQMActionPerformed(evt);
            }
        });

        buttonGroup1.add(TSuqmversionp6014);
        TSuqmversionp6014.setText("Project 6014");
        TSuqmversionp6014.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                TSuqmversionp6014ActionPerformed(evt);
            }
        });

        jLabel9.setText("UQM derivative this tool will be used for:");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(TSuqmversionp6014)
                    .addComponent(TSuqmversionUQM)
                    .addComponent(jLabel9))
                .addContainerGap(116, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel9)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(TSuqmversionUQM)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(TSuqmversionp6014)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel12.setText("Interface");

        setting_NativeLF.setText("Native look & Feel");
        setting_NativeLF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setting_NativeLFActionPerformed(evt);
            }
        });

        setting_rerouteSystemouts.setText("Reroute System.out and System.err to Error Console tab");
        setting_rerouteSystemouts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setting_rerouteSystemoutsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel12)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(setting_NativeLF))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(setting_rerouteSystemouts)))
                .addContainerGap(15, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addComponent(jLabel12)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(setting_NativeLF)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(setting_rerouteSystemouts)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout MainPanel_ToolSettingsLayout = new javax.swing.GroupLayout(MainPanel_ToolSettings);
        MainPanel_ToolSettings.setLayout(MainPanel_ToolSettingsLayout);
        MainPanel_ToolSettingsLayout.setHorizontalGroup(
            MainPanel_ToolSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_ToolSettingsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(MainPanel_ToolSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        MainPanel_ToolSettingsLayout.setVerticalGroup(
            MainPanel_ToolSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_ToolSettingsLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(353, Short.MAX_VALUE))
        );

        MainTabs.addTab("Tool Settings", new javax.swing.ImageIcon(getClass().getResource("/uqmconversation/icons/preferences-desktop.png")), MainPanel_ToolSettings); // NOI18N

        PSettings_DialogFilePNL.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        jLabel1.setText("Load a dialog file from this installation of UQM:");

        Cdd_dialogFilelist.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel13.setText("Import dialog textfile");

        jButton2.setText("Load a dialog file from a file on the harddrive");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout PSettings_DialogFilePNLLayout = new javax.swing.GroupLayout(PSettings_DialogFilePNL);
        PSettings_DialogFilePNL.setLayout(PSettings_DialogFilePNLLayout);
        PSettings_DialogFilePNLLayout.setHorizontalGroup(
            PSettings_DialogFilePNLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PSettings_DialogFilePNLLayout.createSequentialGroup()
                .addGroup(PSettings_DialogFilePNLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(PSettings_DialogFilePNLLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(PSettings_DialogFilePNLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(Cdd_dialogFilelist, javax.swing.GroupLayout.Alignment.TRAILING, 0, 380, Short.MAX_VALUE)
                            .addComponent(jLabel1)))
                    .addComponent(jLabel13)
                    .addGroup(PSettings_DialogFilePNLLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jButton2, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)))
                .addContainerGap())
        );
        PSettings_DialogFilePNLLayout.setVerticalGroup(
            PSettings_DialogFilePNLLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PSettings_DialogFilePNLLayout.createSequentialGroup()
                .addComponent(jLabel13)
                .addGap(6, 6, 6)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cdd_dialogFilelist, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButton2))
        );

        jPanel6.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        Cbt_loadproj.setText("Load project");
        Cbt_loadproj.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_loadprojActionPerformed(evt);
            }
        });

        Cbt_loadproj1.setText("New Project");
        Cbt_loadproj1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_loadproj1ActionPerformed(evt);
            }
        });

        Cbt_saveproj.setText("Save current project");
        Cbt_saveproj.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_saveprojActionPerformed(evt);
            }
        });

        jLabel14.setText("Project operations");

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel14)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(Cbt_loadproj1, javax.swing.GroupLayout.DEFAULT_SIZE, 144, Short.MAX_VALUE)
                            .addComponent(Cbt_loadproj, javax.swing.GroupLayout.DEFAULT_SIZE, 144, Short.MAX_VALUE)))
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(Cbt_saveproj, javax.swing.GroupLayout.DEFAULT_SIZE, 144, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cbt_loadproj)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cbt_loadproj1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cbt_saveproj)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        PSettings_projfilelabel.setText("No project loaded");

        PSettings_FileGeneration.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        btn_Save.setText("Save Dialog Texts");
        btn_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_SaveActionPerformed(evt);
            }
        });

        Cbt_genCode.setText("Show generated code");
        Cbt_genCode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_genCodeActionPerformed(evt);
            }
        });

        Cbt_genStringsh.setText("Show generated strings.h");
        Cbt_genStringsh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_genStringshActionPerformed(evt);
            }
        });

        jLabel2.setText("File generation");

        javax.swing.GroupLayout PSettings_FileGenerationLayout = new javax.swing.GroupLayout(PSettings_FileGeneration);
        PSettings_FileGeneration.setLayout(PSettings_FileGenerationLayout);
        PSettings_FileGenerationLayout.setHorizontalGroup(
            PSettings_FileGenerationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PSettings_FileGenerationLayout.createSequentialGroup()
                .addComponent(jLabel2)
                .addContainerGap(329, Short.MAX_VALUE))
            .addGroup(PSettings_FileGenerationLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btn_Save)
                .addContainerGap(271, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, PSettings_FileGenerationLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(PSettings_FileGenerationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(Cbt_genCode, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(Cbt_genStringsh, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        PSettings_FileGenerationLayout.setVerticalGroup(
            PSettings_FileGenerationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PSettings_FileGenerationLayout.createSequentialGroup()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btn_Save)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(Cbt_genCode)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(Cbt_genStringsh))
        );

        jButton1.setText("Show XML (DEBUG)");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout MainPanel_ProjectSettingsLayout = new javax.swing.GroupLayout(MainPanel_ProjectSettings);
        MainPanel_ProjectSettings.setLayout(MainPanel_ProjectSettingsLayout);
        MainPanel_ProjectSettingsLayout.setHorizontalGroup(
            MainPanel_ProjectSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                .addGroup(MainPanel_ProjectSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(PSettings_projfilelabel))
                    .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                        .addGap(16, 16, 16)
                        .addGroup(MainPanel_ProjectSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(PSettings_DialogFilePNL, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addComponent(PSettings_FileGeneration, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap(552, Short.MAX_VALUE))
        );
        MainPanel_ProjectSettingsLayout.setVerticalGroup(
            MainPanel_ProjectSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                .addGroup(MainPanel_ProjectSettingsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(MainPanel_ProjectSettingsLayout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addComponent(PSettings_projfilelabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, MainPanel_ProjectSettingsLayout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButton1)
                        .addGap(19, 19, 19)))
                .addComponent(PSettings_DialogFilePNL, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(PSettings_FileGeneration, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(159, 159, 159))
        );

        MainTabs.addTab("Project Settings", new javax.swing.ImageIcon(getClass().getResource("/uqmconversation/icons/document-properties.png")), MainPanel_ProjectSettings); // NOI18N

        MainPanel_ConvEd.setPreferredSize(MainTabs.preferredSize());

        Cpnl_left.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        Cbt_newCNode.setText("New ConversationNode");
        Cbt_newCNode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_newCNodeActionPerformed(evt);
            }
        });

        Cbt_newFunction.setText("New Function");
        Cbt_newFunction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Cbt_newFunctionActionPerformed(evt);
            }
        });

        Bt_help.setText("HELP / notes");
        Bt_help.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Bt_helpActionPerformed(evt);
            }
        });

        jButton3.setText("Test conversation in Conversation Simulator");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout Cpnl_leftLayout = new javax.swing.GroupLayout(Cpnl_left);
        Cpnl_left.setLayout(Cpnl_leftLayout);
        Cpnl_leftLayout.setHorizontalGroup(
            Cpnl_leftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Cpnl_leftLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(Cpnl_leftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(Cbt_newCNode, javax.swing.GroupLayout.DEFAULT_SIZE, 336, Short.MAX_VALUE)
                    .addComponent(Cbt_newFunction, javax.swing.GroupLayout.DEFAULT_SIZE, 336, Short.MAX_VALUE)
                    .addComponent(jButton3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 336, Short.MAX_VALUE)
                    .addComponent(Bt_help, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        Cpnl_leftLayout.setVerticalGroup(
            Cpnl_leftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(Cpnl_leftLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(Cbt_newCNode)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cbt_newFunction)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 380, Short.MAX_VALUE)
                .addComponent(Bt_help)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton3)
                .addContainerGap())
        );

        Cpnl_right.setBackground(new java.awt.Color(255, 255, 255));
        Cpnl_right.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout Cpnl_rightLayout = new javax.swing.GroupLayout(Cpnl_right);
        Cpnl_right.setLayout(Cpnl_rightLayout);
        Cpnl_rightLayout.setHorizontalGroup(
            Cpnl_rightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 604, Short.MAX_VALUE)
        );
        Cpnl_rightLayout.setVerticalGroup(
            Cpnl_rightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 508, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout MainPanel_ConvEdLayout = new javax.swing.GroupLayout(MainPanel_ConvEd);
        MainPanel_ConvEd.setLayout(MainPanel_ConvEdLayout);
        MainPanel_ConvEdLayout.setHorizontalGroup(
            MainPanel_ConvEdLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_ConvEdLayout.createSequentialGroup()
                .addComponent(Cpnl_left, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(Cpnl_right, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        MainPanel_ConvEdLayout.setVerticalGroup(
            MainPanel_ConvEdLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, MainPanel_ConvEdLayout.createSequentialGroup()
                .addGroup(MainPanel_ConvEdLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(Cpnl_right, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(Cpnl_left, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        MainTabs.addTab("Project: Conversation Tree Editor", new javax.swing.ImageIcon(getClass().getResource("/uqmconversation/icons/system-users.png")), MainPanel_ConvEd); // NOI18N

        MainPanel_textEd.setPreferredSize(MainTabs.preferredSize());

        pnl_Left.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        pnl_Left.setPreferredSize(new java.awt.Dimension(375, 677));

        pnl_Left_Inner.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jLabel3.setText("Alien Dialogue:");

        jLabel4.setText("Zelnick Dialogue:");

        list_AlienD.setFont(new java.awt.Font("Lucida Console", 0, 11));
        list_AlienD.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        list_AlienD.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                list_AlienDKeyPressed(evt);
            }
        });
        jScrollPane1.setViewportView(list_AlienD);

        list_ZelnickD.setFont(new java.awt.Font("Lucida Console", 0, 11));
        list_ZelnickD.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        list_ZelnickD.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                list_ZelnickDKeyPressed(evt);
            }
        });
        jScrollPane2.setViewportView(list_ZelnickD);

        bt_lp_newAlien.setText("New entry");
        bt_lp_newAlien.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bt_lp_newAlienActionPerformed(evt);
            }
        });

        bt_lp_newZelnick.setText("New entry");
        bt_lp_newZelnick.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bt_lp_newZelnickActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnl_Left_InnerLayout = new javax.swing.GroupLayout(pnl_Left_Inner);
        pnl_Left_Inner.setLayout(pnl_Left_InnerLayout);
        pnl_Left_InnerLayout.setHorizontalGroup(
            pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                        .addGap(11, 11, 11)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 165, Short.MAX_VALUE)
                        .addComponent(bt_lp_newZelnick))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_Left_InnerLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 329, Short.MAX_VALUE)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 329, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, pnl_Left_InnerLayout.createSequentialGroup()
                                .addComponent(jLabel3)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 175, Short.MAX_VALUE)
                                .addComponent(bt_lp_newAlien)))))
                .addContainerGap())
        );
        pnl_Left_InnerLayout.setVerticalGroup(
            pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_Left_InnerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(bt_lp_newAlien))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 164, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_Left_InnerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(bt_lp_newZelnick))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 214, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        btn_Help.setText("Help!");
        btn_Help.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_HelpActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnl_LeftLayout = new javax.swing.GroupLayout(pnl_Left);
        pnl_Left.setLayout(pnl_LeftLayout);
        pnl_LeftLayout.setHorizontalGroup(
            pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_LeftLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(pnl_Left_Inner, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btn_Help, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        pnl_LeftLayout.setVerticalGroup(
            pnl_LeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_LeftLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btn_Help)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnl_Left_Inner, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pnl_Right.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        textarea_rp_dialogString.setColumns(20);
        textarea_rp_dialogString.setLineWrap(true);
        textarea_rp_dialogString.setRows(5);
        textarea_rp_dialogString.setWrapStyleWord(true);
        jScrollPane3.setViewportView(textarea_rp_dialogString);

        btn_rp_Save.setText("Save");
        btn_rp_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_rp_SaveActionPerformed(evt);
            }
        });

        btn_rp_Cancel.setText("Cancel");
        btn_rp_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_rp_CancelActionPerformed(evt);
            }
        });

        jLabel5.setText("Identifier");

        jLabel6.setText("Voice filename");

        jLabel7.setText("Dialog text:");

        javax.swing.GroupLayout pnl_RightLayout = new javax.swing.GroupLayout(pnl_Right);
        pnl_Right.setLayout(pnl_RightLayout);
        pnl_RightLayout.setHorizontalGroup(
            pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_RightLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 569, Short.MAX_VALUE)
                    .addComponent(jLabel7)
                    .addGroup(pnl_RightLayout.createSequentialGroup()
                        .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel6)
                            .addComponent(jLabel5))
                        .addGap(18, 18, 18)
                        .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(text_rp_identifier, javax.swing.GroupLayout.DEFAULT_SIZE, 483, Short.MAX_VALUE)
                            .addComponent(text_rp_filename, javax.swing.GroupLayout.DEFAULT_SIZE, 483, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnl_RightLayout.createSequentialGroup()
                        .addComponent(btn_rp_Cancel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 447, Short.MAX_VALUE)
                        .addComponent(btn_rp_Save)))
                .addContainerGap())
        );
        pnl_RightLayout.setVerticalGroup(
            pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnl_RightLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(text_rp_identifier, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(text_rp_filename, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(21, 21, 21)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 381, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnl_RightLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btn_rp_Save)
                    .addComponent(btn_rp_Cancel))
                .addContainerGap())
        );

        javax.swing.GroupLayout MainPanel_textEdLayout = new javax.swing.GroupLayout(MainPanel_textEd);
        MainPanel_textEd.setLayout(MainPanel_textEdLayout);
        MainPanel_textEdLayout.setHorizontalGroup(
            MainPanel_textEdLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MainPanel_textEdLayout.createSequentialGroup()
                .addComponent(pnl_Left, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnl_Right, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        MainPanel_textEdLayout.setVerticalGroup(
            MainPanel_textEdLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(pnl_Left, javax.swing.GroupLayout.DEFAULT_SIZE, 521, Short.MAX_VALUE)
            .addComponent(pnl_Right, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        MainTabs.addTab("Project: Text Editor", new javax.swing.ImageIcon(getClass().getResource("/uqmconversation/icons/accessories-text-editor.png")), MainPanel_textEd); // NOI18N

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel2.setPreferredSize(new java.awt.Dimension(970, 200));

        jLabel10.setText("Output console:");

        CONSOLE_out.setColumns(20);
        CONSOLE_out.setEditable(false);
        CONSOLE_out.setRows(5);
        jScrollPane4.setViewportView(CONSOLE_out);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(18, 18, 18)
                .addComponent(jLabel10)
                .addGap(875, 875, 875))
            .addComponent(jScrollPane4, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 970, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 180, Short.MAX_VALUE))
        );

        jSplitPane1.setLeftComponent(jPanel2);

        jPanel3.setPreferredSize(new java.awt.Dimension(400, 201));

        jLabel11.setText("Error console:");

        CONSOLE_err.setColumns(20);
        CONSOLE_err.setEditable(false);
        CONSOLE_err.setRows(5);
        jScrollPane7.setViewportView(CONSOLE_err);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jLabel11)
                .addContainerGap(903, Short.MAX_VALUE))
            .addComponent(jScrollPane7, javax.swing.GroupLayout.DEFAULT_SIZE, 970, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jLabel11)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane7, javax.swing.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE))
        );

        jSplitPane1.setRightComponent(jPanel3);

        MainTabs.addTab("Error Console", new javax.swing.ImageIcon(getClass().getResource("/uqmconversation/icons/utilities-terminal.png")), jSplitPane1); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(MainTabs, javax.swing.GroupLayout.DEFAULT_SIZE, 977, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(MainTabs, javax.swing.GroupLayout.DEFAULT_SIZE, 551, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void Cbt_newCNodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_newCNodeActionPerformed
        ConvoNodePanel pnl = new ConvoNodePanel(new Dimension(100, 100), Cpnl_right, null, convo);
        panels.add(pnl);
    }//GEN-LAST:event_Cbt_newCNodeActionPerformed

    private void Cbt_genCodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_genCodeActionPerformed
        TextEditor te = new TextEditor(this, convo.getCode().render(), true);
        te.setVisible(true);
    }//GEN-LAST:event_Cbt_genCodeActionPerformed

    private void Cbt_saveprojActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_saveprojActionPerformed
        String xml = XSTREAM.toXML(convo);
        JFileChooser fc = new JFileChooser(TOOLSETTINGS.getSettingString("DIALOG_lastProjectPath", "."));
        int returnval = fc.showSaveDialog(this);
        if (returnval == fc.APPROVE_OPTION) {
            FileWriter fr = null;
            try {
                fr = new FileWriter(fc.getSelectedFile());
                TOOLSETTINGS.setSetting("DIALOG_lastProjectPath", fc.getSelectedFile().getParent());
                fr.write(xml);
                fr.close();
            } catch (IOException ex) {
                Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                try {
                    fr.close();
                } catch (IOException ex) {
                    Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Nothing saved");
        }
    }//GEN-LAST:event_Cbt_saveprojActionPerformed

    private void Cbt_newFunctionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_newFunctionActionPerformed
        FunctionPanel pnl = new FunctionPanel(new Dimension(100, 100), Cpnl_right, null, convo);
        panels.add(pnl);
    }//GEN-LAST:event_Cbt_newFunctionActionPerformed

    private void Cbt_genStringshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_genStringshActionPerformed
        TextEditor te = new TextEditor(this, convo.generateStringsH(), true);
        te.setVisible(true);
    }//GEN-LAST:event_Cbt_genStringshActionPerformed

    private void Cbt_loadprojActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_loadprojActionPerformed
        Cpnl_right.setLayout(new BoxLayout(Cpnl_right, BoxLayout.Y_AXIS));
        JFileChooser fc = new JFileChooser(TOOLSETTINGS.getSettingString("DIALOG_lastProjectPath", "."));
        int retval = fc.showOpenDialog(this);
        Cpnl_right.removeAll();
        panels.clear();
        int iy = 0;
        if (retval == fc.APPROVE_OPTION) {
            try {
                convo = (Conversation) XSTREAM.fromXML(new FileInputStream(fc.getSelectedFile()));
                TOOLSETTINGS.setSetting("DIALOG_lastProjectPath", fc.getSelectedFile().getParent());
            } catch (FileNotFoundException ex) {
                Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, "WILD ERROR OCCURED: " + ex.getMessage());
            }
            for (Function f : convo.getCode().getFunctions()) {
                if (f.getClass() == ConvoNode.class) {
                    ConvoNode cn = (ConvoNode) f;
                    ConvoNodePanel cnp = new ConvoNodePanel(new Dimension(100, 100), Cpnl_right, cn, convo);
                    cnp.setLocation(0, iy);
                    iy += 40;
                    panels.add(cnp);
                } else {
                    FunctionPanel fnp = new FunctionPanel(new Dimension(100, 100), Cpnl_right, f, convo);
                    fnp.setLocation(0, iy);
                    iy += 40;
                    panels.add(fnp);
                }
            }
            list_AlienD.updateUI();
            list_ZelnickD.updateUI();
        } else {
            JOptionPane.showMessageDialog(rootPane, "No file loaded");
        }
        hideShowStuff_convo();
        Cpnl_right.setLayout(null);
    }//GEN-LAST:event_Cbt_loadprojActionPerformed

    public void setEditing(Dialog_Entry de, Dialog_Entry.E_dialogType fromList, boolean is_new) {
        pnl_Right.setVisible(true);
        editingEntry = de;
        editingFromList = fromList;
        editingNew = is_new;

        if (editingEntry == null || editingFromList == null) {
            textarea_rp_dialogString.setText("");
            text_rp_filename.setText("");
            text_rp_identifier.setText("");
        } else {
            textarea_rp_dialogString.setText(editingEntry.dialogString);
            text_rp_filename.setText(editingEntry.voiceFilename);
            text_rp_identifier.setText(editingEntry.dialogIdentifier);
        }

        if (is_new) {
            pnl_Right.setBackground(SystemColor.YELLOW);
        } else {
            pnl_Right.setBackground(SystemColor.control);
        }
    }

    private void Bt_helpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Bt_helpActionPerformed
        String help = "<html><b><i>Note: this information might be out-of-date!</i></b><br><br><b>Thanks for testing out UQMConversationTool.</b><br>"
                + "<br>"
                + "Note: This tool is VERY ALPHA and not too usable.<br>"
                + "Although you *can* use this tool in a production environment, I do not recommend this at all.<br>"
                + "Future editions of the tool might not be backwards-compatible to projects saved with this one.<br>"
                + "Besides, the usability of this current version of the tool is.. well.. not very good.. :)<br>"
                + "<i>Please report any annoyances, stupidities and general screw-ups to me</i><br>"
                + "<br>"
                + "<b>Here's a quick tutorial to get you started using this tool..</b><br>"
                + "<li>Load a dialogue file by selecting one from the drop-down box.<br>"
                + "<li>Create a new function: 'init_encounter'<br>"
                + "<li>Create a new conversation node: 'main_node'. It'll overlap the init_encounter function in the graphical display. Drag it away with the left mouse button. Generated code will be displayed in a tooltip when you hover the mouse over a conversation node or function.<br>"
                + "<li>Create a new function: 'end_encounter'<br>"
                + "<li>Rightclick on the 'init_encounter' function. In the dialog that appears, hit the 'new statement' button. Navigate to the 'NPCPhrase' tab and select a phrase from the list that corresponds to the Alien's welcome message you want to show. Hit save.<br>"
                + "<li>Hit the 'new statement' button again. Navigate to the last tab ('FunctionCall'), select the 'main_node' function from the list and hit save. This will move the conversation over to the main conversation node..<br>"
                + "<li>Close the function editing dialog<br>"
                + "<li>Rightclick on the 'end_encounter' function. Add a new 'custom code' statement with the following text: <pre>SET_GAME_STATE (BATTLE_SEGUE, 0);</pre> This will prevent a battle to occur once the conversation is done. Close the function editor.<br>"
                + "<li>Rightclick on the 'main_node' conversation node, and in the dialog that appears, hit 'new conversation option'. This will open up a conversation option editor.<br>"
                + "<li>In the conversation option editor, select a phrase Zelnick (the player) can say, select what the NPC(Alien)'s response should be, and set what function/conversation node the game should move to once the alien has stopped talking. "
                + " Optionally, hit the 'disable phrase' checkbox to prevent Zelnick from ever uttering that option again. Create a few conversation options where zelnick says something, the alien responds, and we move back to the 'main_node' conversation node. Also create one conversation option that moves to the 'end_encounter' function. This will be our \"goodbye\" option.<br>"
                + "<li>Close the function editor and <i>pat yourself on the back, since you've just gotten the core basics down of UQMConversationTool! Woo-hoo! :D</i><br>"
                + "<li>Save the current project. File type can be anything, but I recommend something you can remember. Load the file again and notice that I haven't implemented saving of all these graphical widgets yet. Sorry!<br>"
                + "<br>"
                + "<b>Are you capable of compiling UQM's source codes and willing to see your conversations in-game? Read on!</b><br>"
                + "Note: I am no expert on the existing codebase. I know how to generate conversations, but I have no idea how everything works. In other words, it's best to start with an existing .c file for whatever race you've just made a conversation for.<br>"
                + "First of all, take the strings.h file and replace it entirely with the code that's generated once you hit the 'Generate strings.h' button<br>"
                + "Now take the .c file and rip out everything except the #include statements and the LOCDATA parts. Hit the 'Generate Code!' button and copy-paste the entire contents inbetween both LOCDATA parts.<br>"
                + "Edit the '$SOMETHING.init_encounter_func = $SOMEFUNCTION' bit in the .c file; replace $SOMEFUNCTION with 'init_encounter', the function we've made ourselves earlier. For example, in my chmmr.c, it now says: <pre>chmmr_desc.init_encounter_func = init_encounter;</pre><br>"
                + "Compile and pray. It should work nicely... Hopefully.. :P<br>"
                + "<br>"
                + "<b><i>Notes:</i></b><br><i>"
                + "-A dialog file is loaded once, and then embedded inside the save project. This means that you don't have to load a dialog file every time after loading in a project file. In future versions of this tool, the features of 'UQMDialogtool' will be integrated neatly so that dialogs can be edited properly without saving back to a UQM-formatted text file every time.<br>"
                + "-The GUI is kind of shitty right now. Expect that to change later.<br>"
                + "-Later versions of this tool will probably have a nicer graphical display of functions and conversation nodes..<br>"
                + "-I know my generated code is uber-nasty. I also know that my own code isn't the prettiest code on earth. Both may get fixed later.<br>"
                + "-I hope to have some kind of 'autobuild' system set-up in the future where you can instantly generate source-code, strings.h and UQM dialogue .txt file.<br>"
                + "</html>".replace("\n", "<br>");

        TextEditor te = new TextEditor(this, help, true);
        te.setVisible(true);
    }//GEN-LAST:event_Bt_helpActionPerformed

    private void bt_lp_newAlienActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bt_lp_newAlienActionPerformed
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.alien;
        setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.alien, true);
}//GEN-LAST:event_bt_lp_newAlienActionPerformed

    private void bt_lp_newZelnickActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bt_lp_newZelnickActionPerformed
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.zelnick;
        setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.zelnick, true);
}//GEN-LAST:event_bt_lp_newZelnickActionPerformed

    private void btn_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_SaveActionPerformed
//        AbstractFile absf = saveDialogFile();
//        if (absf != null) {
//            cmb_Encounters.addItem(absf);
//            combobox_files.add(absf);
//            cmb_Encounters.setSelectedIndex(cmb_Encounters.getItemCount() - 1);
//            cmb_Encounters.updateUI();
//        }

        JFileChooser fc = new JFileChooser(TOOLSETTINGS.getSettingString("DIALOG_lastDFilePath", "."));
        int retval = fc.showSaveDialog(this);
        if (retval == fc.APPROVE_OPTION) {
            FileWriter fw = null;
            try {
                TOOLSETTINGS.setSetting("DIALOG_lastDFilePath", fc.getSelectedFile().getParent());
                fw = new FileWriter(fc.getSelectedFile());
                for (Dialog_Entry temp : convo.getDialogEntries()) {
                    temp.modified = false;
                    fw.write(temp.render());
                    fw.write("\r\n\r\n");
                }
            } catch (IOException ex) {
                Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                try {
                    fw.close();
                } catch (IOException ex) {
                    Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

}//GEN-LAST:event_btn_SaveActionPerformed

    private void btn_HelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_HelpActionPerformed
        String helpstr = "<html><b>NOTES AND HELP IMPORTED FROM UQMDIALOGTOOL -- MAY CONTAIN ERRORS</b><br><br><br><b>Notes:</b><br>"
                + "-Run UQMDialogTool from within the directory where your UQM binary resides. Otherwise, the tool can't find existing dialogs to edit.<br>"
                + "-UQMDialogTool currently doen't support editing of a dialogue's \"structure\". It only supports editing of a dialogue's strings.<br>"
                + "-Any dialogue identifier (the part in a text file after '#(' and before the trailing ')') is considered to belong to the alien if more than 55% of characters are uppercase.<br>"
                + "-Creating a new alien dialogue entry will force the identifier to be UPPERCASE.<br>"
                + "-THERE ARE NO \"YOU MODIFIED THIS AND DIDN'T SAVE IT\" WARNINGS ANYWHERE WITHIN THE DIALOG EDITING TOOL! THIS IS FOR A FUTURE VERSION. YOU ARE HEREBY WARNED!!!<br>"
                + "-If you open a file from an .uqm file, it WILL NOT be saved as an .uqm file. Instead, it'll be saved in content/$EXTRA_SEARCHPATH/comm/$FILENAME.TXT<br>"
                + "<br><br><b>HELP:</b><br>"
                + "Open a file using the combobox at the top left. The file is parsed and then loaded. <br>"
                + "The lists on the left have the following format: <br>"
                + "DIALOGUE_IDENTIFIER       IS_MODIFIED_CHARACTER  VOICE FILENAME<br>"
                + "where IS_MODIFIED_CHARACTER is '*' if the dialogue string has been modified, and ' ' (blank) if it is not.<br>"
                + "Click on an item in the lists on the left to edit them. If you want to create a new item,  hit a \"new entry\" button.<br>"
                + "Everything else should be pretty self-explanatory. Please tell me if you need any further assistance. :)<br></html>";
        TextEditor te = new TextEditor(this, helpstr, true);
        te.setVisible(true);
}//GEN-LAST:event_btn_HelpActionPerformed

    private void btn_rp_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_rp_SaveActionPerformed
        if (editingEntry != null && editingFromList != null) {
            if (editingNew && (editingFromList == Dialog_Entry.E_dialogType.alien)) {
                text_rp_identifier.setText(text_rp_identifier.getText().toUpperCase()); //Force uppercase to prevent people from making mistakes
            }

            editingEntry.modified = true;
            editingEntry.dialogIdentifier = text_rp_identifier.getText().replace(" ", "_").replace("-",  "_");
            editingEntry.dialogString = textarea_rp_dialogString.getText();
            editingEntry.voiceFilename = text_rp_filename.getText();
            editingEntry.finalize_init();
            editingEntry.type = editingFromList;

            if (editingNew) {
                if (editingFromList == Dialog_Entry.E_dialogType.alien) {
                    addDialogEntry(editingEntry);
                    list_AlienD.setSelectedIndex(list_AlienD.getModel().getSize() - 1);
                } else if (editingFromList == Dialog_Entry.E_dialogType.zelnick) {
                    addDialogEntry(editingEntry);
                    list_ZelnickD.setSelectedIndex(list_ZelnickD.getModel().getSize() - 1);
                }
            }
            list_AlienD.updateUI();
            list_ZelnickD.updateUI();
            pnl_Right.setVisible(false);
        }
}//GEN-LAST:event_btn_rp_SaveActionPerformed

    private void btn_rp_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_rp_CancelActionPerformed
        setEditing(null, null, false);
        pnl_Right.setVisible(false);
}//GEN-LAST:event_btn_rp_CancelActionPerformed

    private void refresh_uqmversion() {
        if (TSuqmversionUQM.isSelected()) {
            TOOLSETTINGS.setSetting("UQMVERSION", "UQM");
            TOOLSETTINGS.setSetting("EXTRA_SEARCHPATH", "");
        } else if (TSuqmversionp6014.isSelected()) {
            TOOLSETTINGS.setSetting("UQMVERSION", "P6014");
            TOOLSETTINGS.setSetting("EXTRA_SEARCHPATH", "base");
        }
        try {
            filelist.refresh();
            init_refreshDialogFileList();
            Cdd_dialogFilelist.updateUI();
        } catch (ZipException ex) {
            Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setting_NativeLFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setting_NativeLFActionPerformed
        if (setting_NativeLF.isSelected()) {
            JOptionPane.showMessageDialog(rootPane, "<html>Native Look and Feel enabled. Please restart this tool.<br> Note: I am not responsible for any sudden GUI fuckups when you have native look and feel enabled! :)</html>");
        }
    }//GEN-LAST:event_setting_NativeLFActionPerformed

    private void Cbt_loadproj1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Cbt_loadproj1ActionPerformed
        convo = new Conversation();
        panels.clear();
        Cpnl_right.removeAll();
        Cpnl_right.updateUI();
        editingEntry = null;
        editingFromList = null;
        editingNew = false;
        hideShowStuff_convo();
    }//GEN-LAST:event_Cbt_loadproj1ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        String xml = XSTREAM.toXML(convo);
        new TextEditor(this, xml, true).setVisible(true);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void list_AlienDKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_list_AlienDKeyPressed
        if (evt.getKeyCode() == 127) {
            convo.getDialogEntries().remove(list_AlienD.getSelectedValue());
            list_AlienD.updateUI();
            list_ZelnickD.updateUI();
            pnl_Right.setVisible(false);
        }
    }//GEN-LAST:event_list_AlienDKeyPressed

    private void list_ZelnickDKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_list_ZelnickDKeyPressed
        if (evt.getKeyCode() == 127) {
            convo.getDialogEntries().remove(list_ZelnickD.getSelectedValue());
            list_AlienD.updateUI();
            list_ZelnickD.updateUI();
            pnl_Right.setVisible(false);
        }
    }//GEN-LAST:event_list_ZelnickDKeyPressed

    private void TSuqmversionp6014ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_TSuqmversionp6014ActionPerformed
        refresh_uqmversion();
    }//GEN-LAST:event_TSuqmversionp6014ActionPerformed

    private void TSuqmversionUQMActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_TSuqmversionUQMActionPerformed
        refresh_uqmversion();
    }//GEN-LAST:event_TSuqmversionUQMActionPerformed

    private void setting_rerouteSystemoutsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setting_rerouteSystemoutsActionPerformed
        JOptionPane.showMessageDialog(rootPane, "Please restart this tool for this setting to apply");
    }//GEN-LAST:event_setting_rerouteSystemoutsActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        JFileChooser fc = new JFileChooser(TOOLSETTINGS.getSettingString("DIALOG_lastDFilePath", "."));
        int retval = fc.showOpenDialog(this);
        if (retval == fc.APPROVE_OPTION) {
            try {
                AbstractFile af = new AbstractFile(fc.getSelectedFile());
                TOOLSETTINGS.setSetting("DIALOG_lastDFilePath", fc.getSelectedFile().getParent());
                int parsed = 0;
                parsed = parseDialogFile(af.getBufferedReader());
                list_AlienD.updateUI();
                list_ZelnickD.updateUI();
                Cdd_dialogFilelist.setSelectedIndex(0);
                Cdd_dialogFilelist.updateUI();
                JOptionPane.showMessageDialog(rootPane, "Added " + parsed + " dialog entries! - Now got " + convo.getDialogEntries().size() + " entries in total!");
            } catch (IOException ex) {
                Logger.getLogger(UQMConversationTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        ConversationSim cs = new ConversationSim(convo); //no setvisible needed
    }//GEN-LAST:event_jButton3ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new UQMConversationTool().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Bt_help;
    private javax.swing.JTextArea CONSOLE_err;
    private javax.swing.JTextArea CONSOLE_out;
    private javax.swing.JButton Cbt_genCode;
    private javax.swing.JButton Cbt_genStringsh;
    private javax.swing.JButton Cbt_loadproj;
    private javax.swing.JButton Cbt_loadproj1;
    private javax.swing.JButton Cbt_newCNode;
    private javax.swing.JButton Cbt_newFunction;
    private javax.swing.JButton Cbt_saveproj;
    private javax.swing.JComboBox Cdd_dialogFilelist;
    private javax.swing.JPanel Cpnl_left;
    private javax.swing.JPanel Cpnl_right;
    private javax.swing.JPanel MainPanel_ConvEd;
    private javax.swing.JPanel MainPanel_ProjectSettings;
    private javax.swing.JPanel MainPanel_ToolSettings;
    private javax.swing.JPanel MainPanel_textEd;
    private javax.swing.JTabbedPane MainTabs;
    private javax.swing.JPanel PSettings_DialogFilePNL;
    private javax.swing.JPanel PSettings_FileGeneration;
    private javax.swing.JLabel PSettings_projfilelabel;
    private javax.swing.JRadioButton TSuqmversionUQM;
    private javax.swing.JRadioButton TSuqmversionp6014;
    private javax.swing.JButton bt_lp_newAlien;
    private javax.swing.JButton bt_lp_newZelnick;
    private javax.swing.JButton btn_Help;
    private javax.swing.JButton btn_Save;
    private javax.swing.JButton btn_rp_Cancel;
    private javax.swing.JButton btn_rp_Save;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane7;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JList list_AlienD;
    private javax.swing.JList list_ZelnickD;
    private javax.swing.JPanel pnl_Left;
    private javax.swing.JPanel pnl_Left_Inner;
    private javax.swing.JPanel pnl_Right;
    private javax.swing.JCheckBox setting_NativeLF;
    private javax.swing.JCheckBox setting_rerouteSystemouts;
    private javax.swing.JTextField text_rp_filename;
    private javax.swing.JTextField text_rp_identifier;
    private javax.swing.JTextArea textarea_rp_dialogString;
    // End of variables declaration//GEN-END:variables

    private void addDialogEntry(Dialog_Entry editingEntry) {
        convo.addDialogEntry(editingEntry);
    }

    public void updatePanels() {
        for (JPanel p : panels) {
            p.updateUI();
        }
    }
}
