/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.UUID;

@XStreamAlias("convoOption")
public class ConvoOption {

    private Function function;
    private UQMZelnickResponse zelnickResponse;

    public ConvoOption(Dialog_Entry zelnickOption, ArrayList<Dialog_Entry> alienPhrases, Function nextFunction, Boolean disablePhrase) {
        refresh(zelnickOption, alienPhrases, nextFunction, disablePhrase);
    }

    public void refresh(Dialog_Entry zelnickOption, ArrayList<Dialog_Entry> alienPhrases, Function nextFunction, Boolean disablePhrase) {
        this.function = new Function(("genF_" + UUID.randomUUID()).replace("-", "_"));
        if (disablePhrase) {
            this.function.addStatement(new UQMDisableResponse(zelnickOption));
        }
        for (Dialog_Entry alienPhrase : alienPhrases) {
            this.function.addStatement(new UQMNPCPhrase(alienPhrase));
        }
        this.function.addStatement(new UQMFunctionCall(nextFunction, "R"));

        this.zelnickResponse = new UQMZelnickResponse(zelnickOption, this.function);
    }

    public UQMZelnickResponse getZelnickResponsestatement() {
        return zelnickResponse;
    }

    public Function getFunction() {
        return function;
    }

    public ArrayList<UQMNPCPhrase> getAlienPhrases() {
        ArrayList<UQMNPCPhrase> retlist = new ArrayList<UQMNPCPhrase>();
        for (Statement s : function.getStatements()) {
            if (s.getClass() == UQMNPCPhrase.class) {
                retlist.add((UQMNPCPhrase) s);
            }
        }
        if (retlist.isEmpty()) {
            System.err.println("Error: getAlienPhrases returned no alien phrase in {" + this.function.getName() + "}!");
        }
        return retlist;
    }

    public Function getNextFunction() {
        for (Statement s : function.getStatements()) {
            if (s.getClass() == UQMFunctionCall.class) {
                return ((UQMFunctionCall) s).getFunction();
            }
        }
        System.err.println("Error: getNextFunction returned no function in {" + this.function.getName() + "}!");
        return null;
    }

    public boolean getDisablePhrase() {
        for (Statement s : function.getStatements()) {
            if (s.getClass() == UQMDisableResponse.class) {
                if (((UQMDisableResponse) s).getDialogEntry() == zelnickResponse.getDialogEntry()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return getZelnickResponsestatement().getDialogEntry().dialogString;
    }
}
