/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

@XStreamAlias("dialogEntry")
public class Dialog_Entry {

    private static String spaces = "                             ";

    public enum E_dialogType {

        zelnick,
        alien
    };
    /**#(NEWS_1)
    Not much, mainly patrolling the quadrant
    and escorting trade ships in case some Kohr-Ah show up.
    Personally, I wish the Alliance allocated more tasks for our fleet.
    The long range of our missiles would complement the
    devastating capabilities of Avatar ships nicely!**/
    @XStreamAsAttribute
    public E_dialogType type;
    @XStreamAsAttribute
    public String dialogIdentifier = "";
    public String dialogString = "";
    public String voiceFilename = "";
    @XStreamOmitField
    public boolean modified = false;

    public Dialog_Entry(String dialogIdentifier, String dialogString, String voiceFilename) {
        this.type = calcDialogType(dialogIdentifier);
        this.dialogIdentifier = dialogIdentifier;
        this.dialogString = dialogString;
        this.voiceFilename = voiceFilename;
    }

    public Dialog_Entry() {
    }

    private void calcDialogType() {
        type = calcDialogType(dialogIdentifier);
    }

    public void finalize_init() {
        calcDialogType();
        dialogString = dialogString.replace(System.getProperty("line.separator"), "\r\n");
        if (dialogString.endsWith("\r\n")) {
            dialogString = dialogString.substring(0, dialogString.length() - 2);
        }
        dialogIdentifier.replace("-", "_");
        //dialogString = dialogString.trim();
    }

    private E_dialogType calcDialogType(String dialogIdentifier) {
        E_dialogType rettype;
        int numupper = 0;
        int numlower = 0;
        int total = dialogIdentifier.length();
        for (char c : dialogIdentifier.toCharArray()) {
            if (Character.isUpperCase(c)) {
                numupper++;
            } else {
                numlower++;
            }
        }
        if (((numupper * 100) / total) > 55) { // More than 55% of the dialog identifier is uppercase -> assume it is an Alien dialog type!
            rettype = E_dialogType.alien;
        } else {
            rettype = E_dialogType.zelnick;
        }
        return rettype;
    }

    @Override
    public String toString() {
        String tspaces = spaces.substring(0, Math.max(0, spaces.length() - dialogIdentifier.length()));
        return dialogIdentifier + tspaces + " " + (modified ? "*" : " ") + " " + voiceFilename;
    }

    public String render() {
        String retstring = "#(" + dialogIdentifier + ")";
        if (!voiceFilename.equals("")) {
            retstring += " " + voiceFilename;
        }
        retstring += "\r\n";
        retstring += dialogString;
        return retstring;
    }
}
