/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;

@XStreamAlias("function")
public class Function {

    private String name;
    private ArrayList<Statement> statements;

    public Function(String name) {
        this.name = name;
        statements = new ArrayList<Statement>();
    }

    public String render_definition() {
        String retstr = "static void\n"
                + name + " (RESPONSE_REF R)\n"
                + "{\n"
                + "\t//START BODY GENERATE\n";
        for (Statement s : statements) {
            retstr += "\t" + s.render() + "\n";
        }
        retstr += "\t//END BODY GENERATE\n"
                + "}\n";
        return retstr;
    }

    public String render_declaration() {
        return "static void\n"
                + name + " (RESPONSE_REF R);\n";
    }

    public String getName() {
        return name;
    }

    public void addStatement(Statement statement) {
        statements.add(statement);
        if (statement instanceof UQMZelnickResponse) {
            UQMZelnickResponse resp = (UQMZelnickResponse) statement;
            if (resp.getFunction() == this) {
                System.err.println("Warning: possible recursion in " + this.toString() + "!");
            }
        }
    }

    @Override
    public String toString() {
        return "function " + name;
    }

    public ArrayList<Statement> getStatements() {
        return statements;
    }

    public void setName(String name) {
        this.name = name;
    }
}
