/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package uqmconversation.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("UQMFunctionCall")
public class UQMFunctionCall extends Statement {
    private Function function;
    private String arguments;

    public UQMFunctionCall(Function function, String arguments) {
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public String render() {
        return (function.getName() + " (" + arguments + ");").trim();
    }

    @Override
    public String toString() {
        return "[@FunctionCall Statement]";
    }

    public Function getFunction() {
        return function;
    }

    

}
