/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uqmconversation.filestuff;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import uqmconversation.UQMConversationTool;

public class FileList {
    public String COMMDIR = "content\\comm";
    public String PACKDIR = "content\\packages";

    private ArrayList<AbstractFile> filelist;

    public FileList() throws ZipException, IOException {
        filelist = new ArrayList<AbstractFile>();
        refresh();
    }

    public void refresh() throws ZipException, IOException {
        filelist.clear();

        refresh_parseDir("content\\comm", "");
        if (!UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","").equals("")) {
            refresh_parseDir("content\\" + UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","") + "\\comm", UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","").toUpperCase());
        }

        refresh_parseUQM(PACKDIR);
    }

    public void setFilelist(ArrayList<AbstractFile> filelist) {
        this.filelist = filelist;
    }

    public void setCOMMDIR(String COMMDIR) {
        this.COMMDIR = COMMDIR;
    }

    public void setPACKDIR(String PACKDIR) {
        this.PACKDIR = PACKDIR;
    }

    

    public void refresh_parseUQM(String packagesDirStr) throws ZipException, IOException {
        File packagesdir = new File(packagesDirStr);
        if (packagesdir.exists()) {
            File[] uqmfiles = packagesdir.listFiles(new FilenameFilter() {

                public boolean accept(File dir, String name) {
                    return name.endsWith(".uqm");
                }
            });
            for (File uqmfile : uqmfiles) {
                ZipFile zipfile = new ZipFile(uqmfile);
                Enumeration e = zipfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry) e.nextElement();
                    if (entry.getName().matches(".*/?comm/\\S*/\\S*\\.txt") || entry.getName().matches(UQMConversationTool.TOOLSETTINGS.getSettingString("EXTRA_SEARCHPATH","") + "/comm/\\S*/\\S*\\.txt")) {
                        AbstractFile abs = new AbstractFile(zipfile, entry);
                        filelist.add(abs);
                    }
                }
            }
        }
    }

    public void refresh_parseDir(String dirStr, String header) throws IOException {
        File dir = new File(dirStr);  //TODO: fix this. :)

        File[] files = dir.listFiles();
        ArrayList<File> dialogfiles = new ArrayList<File>();
        if (files == null) {
            //
        } else {
            for (File file : files) {
                // Get filename of file or directory
                if (file.isDirectory()) {
                    File[] textfiles = file.listFiles(new FilenameFilter() {

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".txt");
                        }
                    });
                    dialogfiles.addAll(Arrays.asList(textfiles));
                }
            }
        }

        for (File dialogfile : dialogfiles) {
            AbstractFile abs = new AbstractFile(dialogfile);
            abs.fheader = header;
            filelist.add(abs);
        }
    }

    public ArrayList<AbstractFile> getFilelist() {
        return filelist;
    }

    
}
