/*
 * Decompiled with CFR 0.152.
 */
package uqmdialogtool;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uqmdialogtool.Notes_and_help;
import uqmdialogtool.StringsH;
import uqmdialogtool.dialogue.Dialog_Entry;
import uqmdialogtool.uqmbase.AbstractFile;

public class MainFrame
extends JFrame {
    ArrayList<AbstractFile> combobox_files;
    DefaultListModel dmList_Alien = new DefaultListModel();
    DefaultListModel dmList_Zelnick = new DefaultListModel();
    ArrayList<Dialog_Entry> MasterList = new ArrayList();
    Dialog_Entry editingEntry;
    Dialog_Entry.E_dialogType editingFromList;
    boolean editingNew = true;
    public static String extra_searchpath;
    private String UQMDIALOGTOOL_VERSION_STRING = "UQMDialogTool v0.5";
    private JButton bt_lp_newAlien;
    private JButton bt_lp_newZelnick;
    private JButton btn_Help;
    private JButton btn_Save;
    private JButton btn_genstringsh;
    private JButton btn_rp_Cancel;
    private JButton btn_rp_Save;
    private JComboBox cmb_Encounters;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList list_AlienD;
    private JList list_ZelnickD;
    private JPanel pnl_Left;
    private JPanel pnl_Left_Inner;
    private JPanel pnl_Right;
    private JTextField text_rp_filename;
    private JTextField text_rp_identifier;
    private JTextArea textarea_rp_dialogString;

    public MainFrame(String extra_searchpath, boolean nobugging) {
        this.initComponents();
        this.setTitle(this.UQMDIALOGTOOL_VERSION_STRING);
        MainFrame.extra_searchpath = extra_searchpath;
        this.pnl_Right.setVisible(false);
        this.pnl_Left_Inner.setVisible(false);
        try {
            this.refreshCombobox();
        }
        catch (ZipException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.list_AlienD.setModel(this.dmList_Alien);
        this.list_ZelnickD.setModel(this.dmList_Zelnick);
        this.cmb_Encounters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrame.this.parseDialogfile(MainFrame.this.combobox_files.get(MainFrame.this.cmb_Encounters.getSelectedIndex()).getBufferedReader());
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
                MainFrame.this.pnl_Left_Inner.setVisible(true);
                MainFrame.this.btn_Save.setEnabled(true);
                MainFrame.this.btn_genstringsh.setEnabled(true);
            }
        });
        this.list_AlienD.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MainFrame.this.list_AlienD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry)MainFrame.this.dmList_Alien.get(MainFrame.this.list_AlienD.getSelectedIndex());
                    MainFrame.this.setEditing(temp, Dialog_Entry.E_dialogType.alien, false);
                    MainFrame.this.list_ZelnickD.clearSelection();
                    MainFrame.this.list_ZelnickD.updateUI();
                }
            }
        });
        this.list_ZelnickD.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MainFrame.this.list_ZelnickD.getSelectedIndex() != -1) {
                    Dialog_Entry temp = (Dialog_Entry)MainFrame.this.dmList_Zelnick.get(MainFrame.this.list_ZelnickD.getSelectedIndex());
                    MainFrame.this.setEditing(temp, Dialog_Entry.E_dialogType.zelnick, false);
                    MainFrame.this.list_AlienD.clearSelection();
                    MainFrame.this.list_AlienD.updateUI();
                }
            }
        });
        if (!nobugging) {
            this.showHelp();
        }
    }

    public void showHelp() {
        Notes_and_help nah = new Notes_and_help((Frame)this, false);
        nah.setVisible(true);
    }

    public void setEditing(Dialog_Entry de, Dialog_Entry.E_dialogType fromList, boolean is_new) {
        this.pnl_Right.setVisible(true);
        this.editingEntry = de;
        this.editingFromList = fromList;
        this.editingNew = is_new;
        if (this.editingEntry == null || this.editingFromList == null) {
            this.textarea_rp_dialogString.setText("");
            this.text_rp_filename.setText("");
            this.text_rp_identifier.setText("");
        } else {
            this.textarea_rp_dialogString.setText(this.editingEntry.dialogString);
            this.text_rp_filename.setText(this.editingEntry.voiceFilename);
            this.text_rp_identifier.setText(this.editingEntry.dialogIdentifier);
        }
    }

    public void saveEntry() {
        if (this.editingEntry != null && this.editingFromList != null) {
            if (this.editingNew && this.editingFromList == Dialog_Entry.E_dialogType.alien) {
                this.text_rp_identifier.setText(this.text_rp_identifier.getText().toUpperCase());
            }
            this.editingEntry.modified = true;
            this.editingEntry.dialogIdentifier = this.text_rp_identifier.getText();
            this.editingEntry.dialogString = this.textarea_rp_dialogString.getText();
            this.editingEntry.voiceFilename = this.text_rp_filename.getText();
            this.editingEntry.finalize_init();
            this.editingEntry.type = this.editingFromList;
            if (this.editingNew) {
                if (this.editingFromList == Dialog_Entry.E_dialogType.alien) {
                    this.MasterList.add(this.editingEntry);
                    this.dmList_Alien.addElement(this.editingEntry);
                    this.list_AlienD.setSelectedIndex(this.dmList_Alien.size() - 1);
                    this.list_AlienD.updateUI();
                } else if (this.editingFromList == Dialog_Entry.E_dialogType.zelnick) {
                    this.MasterList.add(this.editingEntry);
                    this.dmList_Zelnick.addElement(this.editingEntry);
                    this.list_ZelnickD.setSelectedIndex(this.dmList_Zelnick.size() - 1);
                    this.list_ZelnickD.updateUI();
                }
            } else if (this.editingFromList == Dialog_Entry.E_dialogType.alien) {
                this.dmList_Alien.set(this.list_AlienD.getSelectedIndex(), this.editingEntry);
            } else if (this.editingFromList == Dialog_Entry.E_dialogType.zelnick) {
                this.dmList_Zelnick.set(this.list_ZelnickD.getSelectedIndex(), this.editingEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractFile saveDialogFile() {
        AbstractFile retabsf = null;
        OutputStreamWriter fw = null;
        try {
            File f = this.combobox_files.get(this.cmb_Encounters.getSelectedIndex()).getFile();
            fw = new FileWriter(f);
            if (this.combobox_files.get((int)this.cmb_Encounters.getSelectedIndex()).ftype == AbstractFile.FileType.inzipfile) {
                retabsf = new AbstractFile(f);
            }
            for (Dialog_Entry temp : this.MasterList) {
                temp.modified = false;
                fw.write(temp.render());
                fw.write("\r\n\r\n");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.list_AlienD.clearSelection();
        this.list_ZelnickD.clearSelection();
        this.list_AlienD.updateUI();
        this.list_ZelnickD.updateUI();
        return retabsf;
    }

    public void refreshComboBox_parseDir(String dirStr, String header) throws IOException {
        File dir = new File(dirStr);
        File[] files = dir.listFiles();
        ArrayList<File> dialogfiles = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                File[] textfiles = file.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                });
                dialogfiles.addAll(Arrays.asList(textfiles));
            }
        }
        for (File dialogfile : dialogfiles) {
            AbstractFile abs = new AbstractFile(dialogfile);
            abs.fheader = header;
            this.cmb_Encounters.addItem(abs);
            this.combobox_files.add(abs);
        }
    }

    public void refreshComboBos_parseUQM(String packagesDirStr) throws ZipException, IOException {
        File packagesdir = new File(packagesDirStr);
        if (packagesdir.exists()) {
            File[] uqmfiles;
            for (File uqmfile : uqmfiles = packagesdir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".uqm");
                }
            })) {
                ZipFile zipfile = new ZipFile(uqmfile);
                Enumeration<? extends ZipEntry> e = zipfile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().matches(".*/?comm/\\S*/\\S*\\.txt") && !entry.getName().matches(extra_searchpath + "/comm/\\S*/\\S*\\.txt")) continue;
                    AbstractFile abs = new AbstractFile(zipfile, entry);
                    this.cmb_Encounters.addItem(abs);
                    this.combobox_files.add(abs);
                }
            }
        }
    }

    public void refreshCombobox() throws ZipException, IOException {
        this.combobox_files = new ArrayList();
        this.cmb_Encounters.removeAllItems();
        this.refreshComboBox_parseDir("content\\comm", "");
        if (!extra_searchpath.equals("")) {
            this.refreshComboBox_parseDir("content\\" + extra_searchpath + "\\comm", extra_searchpath.toUpperCase());
        }
        this.refreshComboBos_parseUQM("content\\packages");
    }

    public void parseDialogfile(BufferedReader in) {
        try {
            this.dmList_Alien.removeAllElements();
            this.dmList_Zelnick.removeAllElements();
            this.list_AlienD.removeAll();
            this.list_ZelnickD.removeAll();
            this.MasterList.clear();
            boolean parsing = false;
            Dialog_Entry workingEntry = null;
            while (in.ready()) {
                String readline = in.readLine();
                if (readline.startsWith("#(")) {
                    if (parsing) {
                        parsing = false;
                        workingEntry.finalize_init();
                        if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                            this.MasterList.add(workingEntry);
                        } else if (workingEntry.type == Dialog_Entry.E_dialogType.zelnick) {
                            this.MasterList.add(workingEntry);
                        }
                    }
                    parsing = true;
                    String[] splitted = readline.split("\\s");
                    if (splitted.length >= 1) {
                        workingEntry = new Dialog_Entry();
                        workingEntry.dialogIdentifier = splitted[0].replace("#(", "").replace(")", "");
                    }
                    if (splitted.length >= 2) {
                        workingEntry.voiceFilename = splitted[1];
                        continue;
                    }
                    workingEntry.voiceFilename = "";
                    continue;
                }
                if (readline.equals("") && parsing) {
                    parsing = false;
                    workingEntry.finalize_init();
                    if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                        this.MasterList.add(workingEntry);
                        continue;
                    }
                    if (workingEntry.type != Dialog_Entry.E_dialogType.zelnick) continue;
                    this.MasterList.add(workingEntry);
                    continue;
                }
                if (!parsing) continue;
                workingEntry.dialogString = workingEntry.dialogString + readline + "\r\n";
            }
            if (parsing) {
                parsing = false;
                workingEntry.finalize_init();
                if (workingEntry.type == Dialog_Entry.E_dialogType.alien) {
                    this.MasterList.add(workingEntry);
                } else if (workingEntry.type == Dialog_Entry.E_dialogType.zelnick) {
                    this.MasterList.add(workingEntry);
                }
            }
            for (Dialog_Entry de : this.MasterList) {
                if (de.type == Dialog_Entry.E_dialogType.alien) {
                    this.dmList_Alien.addElement(de);
                    continue;
                }
                if (de.type != Dialog_Entry.E_dialogType.zelnick) continue;
                this.dmList_Zelnick.addElement(de);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void generateStringsH() {
        String temp = "//Copyright Paul Reiche, Fred Ford. 1992-2002\n//This file was generated by " + this.UQMDIALOGTOOL_VERSION_STRING + "\n" + "\n" + "/*\n" + "*  This program is free software; you can redistribute it and/or modify\n" + "*  it under the terms of the GNU General Public License as published by\n" + "*  the Free Software Foundation; either version 2 of the License, or\n" + "*  (at your option) any later version.\n" + "*\n" + "*  This program is distributed in the hope that it will be useful,\n" + "*  but WITHOUT ANY WARRANTY; without even the implied warranty of\n" + "*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" + "*  GNU General Public License for more details.\n" + "*\n" + "*  You should have received a copy of the GNU General Public License\n" + "*  along with this program; if not, write to the Free Software\n" + "*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n" + "*/\n" + "\n" + "#ifndef _STRINGS_H\n" + "#define _STRINGS_H\n" + "\n" + "enum\n{\n";
        int num = this.MasterList.size();
        for (Dialog_Entry de : this.MasterList) {
            temp = num > 1 ? temp + "\t" + de.dialogIdentifier + ",\n" : temp + "\t" + de.dialogIdentifier + "\n";
            --num;
        }
        temp = temp + "};\n\n#endif /* _STRINGS_H */\n\n";
        new StringsH((Frame)this, true, temp).setVisible(true);
    }

    private void initComponents() {
        this.pnl_Left = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmb_Encounters = new JComboBox();
        this.pnl_Left_Inner = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list_AlienD = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.list_ZelnickD = new JList();
        this.bt_lp_newAlien = new JButton();
        this.bt_lp_newZelnick = new JButton();
        this.btn_Save = new JButton();
        this.btn_Help = new JButton();
        this.btn_genstringsh = new JButton();
        this.pnl_Right = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.textarea_rp_dialogString = new JTextArea();
        this.btn_rp_Save = new JButton();
        this.btn_rp_Cancel = new JButton();
        this.text_rp_identifier = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.text_rp_filename = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setTitle("UQMDialogTool");
        this.pnl_Left.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnl_Left.setPreferredSize(new Dimension(375, 677));
        this.jLabel1.setText("Encounter (Alien):");
        this.cmb_Encounters.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.pnl_Left_Inner.setBorder(BorderFactory.createBevelBorder(1));
        this.jLabel2.setText("Alien Dialogue:");
        this.jLabel3.setText("Zelnick Dialogue:");
        this.list_AlienD.setFont(new Font("Lucida Console", 0, 11));
        this.list_AlienD.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list_AlienD);
        this.list_ZelnickD.setFont(new Font("Lucida Console", 0, 11));
        this.list_ZelnickD.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.list_ZelnickD);
        this.bt_lp_newAlien.setText("New entry");
        this.bt_lp_newAlien.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.bt_lp_newAlienActionPerformed(evt);
            }
        });
        this.bt_lp_newZelnick.setText("New entry");
        this.bt_lp_newZelnick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.bt_lp_newZelnickActionPerformed(evt);
            }
        });
        GroupLayout pnl_Left_InnerLayout = new GroupLayout(this.pnl_Left_Inner);
        this.pnl_Left_Inner.setLayout(pnl_Left_InnerLayout);
        pnl_Left_InnerLayout.setHorizontalGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_Left_InnerLayout.createSequentialGroup().addGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_Left_InnerLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 165, Short.MAX_VALUE).addComponent(this.bt_lp_newZelnick)).addGroup(GroupLayout.Alignment.TRAILING, pnl_Left_InnerLayout.createSequentialGroup().addContainerGap().addGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, pnl_Left_InnerLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 175, Short.MAX_VALUE).addComponent(this.bt_lp_newAlien))))).addContainerGap()));
        pnl_Left_InnerLayout.setVerticalGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_Left_InnerLayout.createSequentialGroup().addContainerGap().addGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.bt_lp_newAlien)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 273, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnl_Left_InnerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.bt_lp_newZelnick)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 214, -2).addContainerGap()));
        this.btn_Save.setText("Save");
        this.btn_Save.setEnabled(false);
        this.btn_Save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btn_SaveActionPerformed(evt);
            }
        });
        this.btn_Help.setText("Help!");
        this.btn_Help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btn_HelpActionPerformed(evt);
            }
        });
        this.btn_genstringsh.setText("generate strings.h");
        this.btn_genstringsh.setEnabled(false);
        this.btn_genstringsh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btn_genstringshActionPerformed(evt);
            }
        });
        GroupLayout pnl_LeftLayout = new GroupLayout(this.pnl_Left);
        this.pnl_Left.setLayout(pnl_LeftLayout);
        pnl_LeftLayout.setHorizontalGroup(pnl_LeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_LeftLayout.createSequentialGroup().addContainerGap().addGroup(pnl_LeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.cmb_Encounters, 0, 353, Short.MAX_VALUE).addComponent(this.pnl_Left_Inner, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnl_LeftLayout.createSequentialGroup().addComponent(this.btn_Help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 112, Short.MAX_VALUE).addComponent(this.btn_genstringsh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_Save))).addContainerGap()));
        pnl_LeftLayout.setVerticalGroup(pnl_LeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_LeftLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmb_Encounters, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnl_LeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btn_Save).addComponent(this.btn_Help).addComponent(this.btn_genstringsh)).addGap(7, 7, 7).addComponent(this.pnl_Left_Inner, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pnl_Right.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.textarea_rp_dialogString.setColumns(20);
        this.textarea_rp_dialogString.setRows(5);
        this.jScrollPane3.setViewportView(this.textarea_rp_dialogString);
        this.btn_rp_Save.setText("Save");
        this.btn_rp_Save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btn_rp_SaveActionPerformed(evt);
            }
        });
        this.btn_rp_Cancel.setText("Cancel");
        this.btn_rp_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btn_rp_CancelActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Identifier");
        this.jLabel5.setText("Voice filename");
        this.jLabel6.setText("Dialog text:");
        GroupLayout pnl_RightLayout = new GroupLayout(this.pnl_Right);
        this.pnl_Right.setLayout(pnl_RightLayout);
        pnl_RightLayout.setHorizontalGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_RightLayout.createSequentialGroup().addContainerGap().addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 470, Short.MAX_VALUE).addComponent(this.jLabel6).addGroup(pnl_RightLayout.createSequentialGroup().addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.text_rp_identifier, -1, 384, Short.MAX_VALUE).addComponent(this.text_rp_filename, -1, 384, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, pnl_RightLayout.createSequentialGroup().addComponent(this.btn_rp_Cancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 348, Short.MAX_VALUE).addComponent(this.btn_rp_Save))).addContainerGap()));
        pnl_RightLayout.setVerticalGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnl_RightLayout.createSequentialGroup().addContainerGap().addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.text_rp_identifier, -2, 20, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.text_rp_filename, -2, -1, -2)).addGap(21, 21, 21).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 537, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnl_RightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btn_rp_Save).addComponent(this.btn_rp_Cancel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnl_Left, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnl_Right, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pnl_Right, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnl_Left, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void btn_rp_SaveActionPerformed(ActionEvent evt) {
        this.saveEntry();
    }

    private void btn_SaveActionPerformed(ActionEvent evt) {
        AbstractFile absf = this.saveDialogFile();
        if (absf != null) {
            this.cmb_Encounters.addItem(absf);
            this.combobox_files.add(absf);
            this.cmb_Encounters.setSelectedIndex(this.cmb_Encounters.getItemCount() - 1);
            this.cmb_Encounters.updateUI();
        }
    }

    private void btn_rp_CancelActionPerformed(ActionEvent evt) {
        this.setEditing(null, null, false);
        this.pnl_Right.setVisible(false);
    }

    private void bt_lp_newAlienActionPerformed(ActionEvent evt) {
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.alien;
        this.setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.alien, true);
    }

    private void bt_lp_newZelnickActionPerformed(ActionEvent evt) {
        Dialog_Entry temp = new Dialog_Entry();
        temp.type = Dialog_Entry.E_dialogType.zelnick;
        this.setEditing(new Dialog_Entry(), Dialog_Entry.E_dialogType.zelnick, true);
    }

    private void btn_HelpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private void btn_genstringshActionPerformed(ActionEvent evt) {
        this.generateStringsH();
    }
}

