/*
 * Decompiled with CFR 0.152.
 */
package uqmdialogtool.dialogue;

public class Dialog_Entry {
    private static String spaces = "                             ";
    public E_dialogType type;
    public String dialogIdentifier = "";
    public String dialogString = "";
    public String voiceFilename = "";
    public boolean modified = false;

    public Dialog_Entry(String dialogIdentifier, String dialogString, String voiceFilename) {
        this.type = this.calcDialogType(dialogIdentifier);
        this.dialogIdentifier = dialogIdentifier;
        this.dialogString = dialogString;
        this.voiceFilename = voiceFilename;
    }

    public Dialog_Entry() {
    }

    private void calcDialogType() {
        this.type = this.calcDialogType(this.dialogIdentifier);
    }

    public void finalize_init() {
        this.calcDialogType();
        this.dialogString = this.dialogString.replace(System.getProperty("line.separator"), "\r\n");
        if (this.dialogString.endsWith("\r\n")) {
            this.dialogString = this.dialogString.substring(0, this.dialogString.length() - 2);
        }
    }

    private E_dialogType calcDialogType(String dialogIdentifier) {
        int numupper = 0;
        int numlower = 0;
        int total = dialogIdentifier.length();
        for (char c : dialogIdentifier.toCharArray()) {
            if (Character.isUpperCase(c)) {
                ++numupper;
                continue;
            }
            ++numlower;
        }
        E_dialogType rettype = numupper * 100 / total > 55 ? E_dialogType.alien : E_dialogType.zelnick;
        return rettype;
    }

    public String toString() {
        String tspaces = spaces.substring(0, Math.max(0, spaces.length() - this.dialogIdentifier.length()));
        return this.dialogIdentifier + tspaces + " " + (this.modified ? "*" : " ") + " " + this.voiceFilename;
    }

    public String render() {
        String retstring = "#(" + this.dialogIdentifier + ")";
        if (!this.voiceFilename.equals("")) {
            retstring = retstring + " " + this.voiceFilename;
        }
        retstring = retstring + "\r\n";
        retstring = retstring + this.dialogString;
        return retstring;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum E_dialogType {
        zelnick,
        alien;

    }
}

