/*
 * Decompiled with CFR 0.152.
 */
package uqmdialogtool.uqmbase;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uqmdialogtool.MainFrame;

public class AbstractFile {
    public FileType ftype;
    public String fheader = "";
    private File file;
    private ZipFile zipfile;
    private ZipEntry zipentry;

    public AbstractFile(File f) throws IOException {
        int indexof;
        this.ftype = FileType.regularfile;
        this.file = f;
        this.fheader = "";
        if (!f.getPath().startsWith("content\\comm") && (indexof = f.getPath().indexOf("content")) != -1) {
            this.fheader = f.getPath().substring(indexof + 8, f.getPath().length());
            this.fheader = this.fheader.substring(0, this.fheader.indexOf("\\")).toUpperCase();
        }
    }

    public AbstractFile(ZipFile zipfile, ZipEntry zipentry) {
        this.ftype = FileType.inzipfile;
        this.zipfile = zipfile;
        this.zipentry = zipentry;
        this.fheader = zipfile.getName().substring(zipfile.getName().lastIndexOf("\\") + 1, zipfile.getName().length());
    }

    public BufferedReader getBufferedReader() throws IOException {
        if (this.ftype == FileType.inzipfile) {
            BufferedInputStream is = new BufferedInputStream(this.zipfile.getInputStream(this.zipentry));
            InputStreamReader ir = new InputStreamReader(this.zipfile.getInputStream(this.zipentry));
            BufferedReader br = new BufferedReader(ir);
            return br;
        }
        if (this.ftype == FileType.regularfile) {
            return new BufferedReader(new FileReader(this.file));
        }
        return null;
    }

    public File getFile() throws IOException {
        if (this.ftype == FileType.inzipfile) {
            String entryStr = "content/" + (MainFrame.extra_searchpath.equals("") ? "" : MainFrame.extra_searchpath + "/") + this.zipentry.getName();
            File f = new File(entryStr.replace("/", "\\"));
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            return f;
        }
        if (this.ftype == FileType.regularfile) {
            return this.file;
        }
        return null;
    }

    public String getFname() {
        if (this.ftype == FileType.inzipfile) {
            return this.zipentry.getName();
        }
        if (this.ftype == FileType.regularfile) {
            return this.file.getName();
        }
        return "ERROR";
    }

    public String toString() {
        if (this.ftype == FileType.inzipfile) {
            return (!this.fheader.equals("") ? "[" + this.fheader + "]" : "") + this.zipentry.getName();
        }
        if (this.ftype == FileType.regularfile) {
            return (!this.fheader.equals("") ? "[" + this.fheader + "]" : "") + this.getFname();
        }
        return "ERROR";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        regularfile,
        inzipfile;

    }
}

