/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainFrame.java
 *
 * Created on 2-okt-2010, 20:21:42
 */

package uqmnamegen;

import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uqmnamegen.generators.NameGenerator;

/**
 *
 * @author joris
 */
public class MainFrame extends javax.swing.JFrame {
    NameGenerator namegen;
    DefaultListModel patternsmodel = new DefaultListModel();

    /** Creates new form MainFrame */
    public MainFrame() {
        initComponents();
        list_patterns.setModel(patternsmodel);
        list_patterns.addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                text_pattern.setText((String) list_patterns.getSelectedValue());
            }
        });

        namegen = new NameGenerator();
        patternsmodel.removeAllElements();
        for (String pattern : namegen.namepatterns) {
            patternsmodel.addElement(pattern);
        }

        String text = "";
        for (ArrayList<String> as : namegen.patchars.keySet()) {
            text += "[" + namegen.patchars.get(as) + "] -- " + namegen.patnames.get(as) + System.getProperty("line.separator");
            text += "------------------------------" + System.getProperty("line.separator");
            for (String s : as) {
                text += s + System.getProperty("line.separator");
            }
            text += "" + System.getProperty("line.separator") + System.getProperty("line.separator");
        }
        textarea_stuff.setText(textarea_stuff.getText() + text);

        textarea_stuff.setCaretPosition(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        list_patterns = new javax.swing.JList();
        text_pattern = new javax.swing.JTextField();
        btn_generate = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        textarea_results = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        text_ammount = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        textarea_stuff = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jButton2 = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        list_patterns.setFont(new java.awt.Font("Monospaced", 0, 11)); // NOI18N
        list_patterns.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(list_patterns);

        text_pattern.setText("S\\e\\e\\p\\-\\e\\e\\p");

        btn_generate.setText("Generate!");
        btn_generate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btn_generateActionPerformed(evt);
            }
        });

        textarea_results.setColumns(20);
        textarea_results.setRows(5);
        jScrollPane2.setViewportView(textarea_results);

        jButton1.setText("Generate from random pattern in presets");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        text_ammount.setText("18");

        textarea_stuff.setColumns(20);
        textarea_stuff.setEditable(false);
        textarea_stuff.setLineWrap(true);
        textarea_stuff.setRows(5);
        textarea_stuff.setText("-Character between brackets ([]) can be used.\n-Character can be UPPERCASED to result in an UPPERCASED version of whatever character is generated form that list (unless the character belongs to a SPECIAL LIST, see below).\n-Character lists are currently hardcoded; perhaps in the future this will change.\n-A # can be inserted anywhere in patterns.txt to serve as comment. Anything after the # will not be used.\n----------------------------\n\nSpecial lists:\n[u] - Random number (0-9 incl.)\n[U] - Random nonzero number (1-9 incl.)\n[p] - Previous character; lowercase.\n[\\] - Raw. Character generated will ALWAYS be the character after this character.\n\n\n\n\n");
        textarea_stuff.setWrapStyleWord(true);
        jScrollPane3.setViewportView(textarea_stuff);

        jLabel1.setText("Pattern:");

        jLabel2.setText("Amount:");

        jButton2.setText("Clear results");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jLabel3.setText("Presets (patterns.txt):");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jButton1))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addGroup(layout.createSequentialGroup()
                            .addContainerGap()
                            .addComponent(jButton2))
                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                            .addGap(10, 10, 10)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)
                                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)
                                .addGroup(layout.createSequentialGroup()
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jLabel1)
                                        .addComponent(jLabel2))
                                    .addGap(16, 16, 16)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(text_ammount)
                                        .addComponent(text_pattern, javax.swing.GroupLayout.DEFAULT_SIZE, 169, Short.MAX_VALUE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(btn_generate)))))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel3)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 345, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 578, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(4, 4, 4)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 122, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(text_pattern, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(text_ammount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2)
                            .addComponent(btn_generate))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btn_generateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btn_generateActionPerformed
        String text = "";
        try {
        int num = Integer.valueOf(text_ammount.getText());
        for (int i = 0; i < num; i++) {
            text += System.getProperty("line.separator") + namegen.genName(text_pattern.getText());
        }
        textarea_results.setText(text.trim());
        } catch (NumberFormatException ne) {
            JOptionPane.showMessageDialog(this, "ERROR: Please specify a number for the amount!");
        }
    }//GEN-LAST:event_btn_generateActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        String text = "";
        try {
        int num = Integer.valueOf(text_ammount.getText());
        for (int i = 0; i < num; i++) {
            text += System.getProperty("line.separator") + namegen.genRandName();
        }
        textarea_results.setText(text.trim());
        } catch (NumberFormatException ne) {
            JOptionPane.showMessageDialog(this, "ERROR: Please specify a number for the amount!");
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        textarea_results.setText("");
    }//GEN-LAST:event_jButton2ActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btn_generate;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JList list_patterns;
    private javax.swing.JTextField text_ammount;
    private javax.swing.JTextField text_pattern;
    private javax.swing.JTextArea textarea_results;
    private javax.swing.JTextArea textarea_stuff;
    // End of variables declaration//GEN-END:variables

}
